<?php
/*
*	Custom Function File
*	---------------------------------------------------------------------
*/

function theme_enqueue_styles() {
    wp_enqueue_style( 'parent-style', get_template_directory_uri() . '/style.css' );
    wp_enqueue_style( 'bootstrap', get_stylesheet_directory_uri() . '/assets/css/bootstrap.min.css' );
	wp_enqueue_style( 'Lato', 'https://fonts.googleapis.com/css?family=Lato:100,300,400,400i,700,700i,900' );	
    wp_enqueue_style( 'font-awesome', get_stylesheet_directory_uri() . '/assets/css/font-awesome.min.css' );

    
}
add_action( 'wp_enqueue_scripts', 'theme_enqueue_styles' );

function child_theme_style() {
  //wp_enqueue_style( 'child-theme-woocommerce', get_stylesheet_directory_uri() . '/custom-woocommerce-style.css'  );
    wp_enqueue_style( 'child-theme-style', get_stylesheet_directory_uri() . '/custom-style.css'  );
	    wp_enqueue_style( 'child-theme-responsive-style', get_stylesheet_directory_uri() . '/custom-responsive-style.css'  );
	
}
add_action( 'wp_enqueue_scripts', 'child_theme_style', 30 );


function child_theme_scripts() {
    wp_enqueue_script( 'bootstrap', get_stylesheet_directory_uri() . '/assets/js/bootstrap.min.js', array(), '1.0.0', true );  
    wp_enqueue_script( 'custom-script', get_stylesheet_directory_uri() . '/assets/js/custom-script.js', array(), '1.0.0', true );	 
}
add_action( 'wp_enqueue_scripts', 'child_theme_scripts', 50 );

/*******************************
 ADD CUSTOM MENU
********************************/
if ( function_exists( 'wp_nav_menu' ) ){
	if (function_exists('add_theme_support')) {
		add_theme_support('nav-menus');
		add_action( 'init', 'register_my_menus' );
		function register_my_menus() {
			register_nav_menus(
				array(
					'footer-menu' => __( 'Footer Menu' )
				)
			);
		}
	}
}

/*******************************
 ADD CUSTOM THUMB SIZE
********************************/
//add_image_size( 'services-thumb', 360, 200, array( 'left', 'top' ) );



// Remove WP Version From Styles
add_filter( 'style_loader_src', 'sdt_remove_ver_css_js', 9999 );
// Remove WP Version From Scripts
add_filter( 'script_loader_src', 'sdt_remove_ver_css_js', 9999 );

// Function to remove version numbers
function sdt_remove_ver_css_js( $src ) {
	if ( strpos( $src, 'ver=' ) )
		$src = remove_query_arg( 'ver', $src );
	return $src;
}


/* function my_custom_sidebar() {
	register_sidebar( array(
		'name'          => __( 'Product-Filter', 'twentyseventeen-child' ),
		'id'            => 'product-filter',
		'description'   => __( 'Add widgets here to appear in your sidebar.', 'twentyseventeen-child' ),
		'before_widget' => '<section id="%1$s" class="widget %2$s">',
		'after_widget'  => '</section>',
		'before_title'  => '<h2 class="widget-title">',
		'after_title'   => '</h2>',
	) );
}
add_action( 'widgets_init', 'my_custom_sidebar' ); */

///////////////////////////////

//    Slider 

//////////////////////////////

add_action( 'init', 'create_slider' );
function create_slider() {
	register_post_type( 'slider',
		array(
			'labels' => array(
				'name' => __( 'Slider' ),
				'singular_name' => __( 'Slider' )
			),
			'public' => true,
			'has_archive' => true,
			'rewrite' => array('slug' => 'slider'),
			'supports'      => array( 'title', 'editor', 'thumbnail' ),
    		'menu_position' => 20,
			'post_type' => 'attachment',

		)
	);
}

function slider_add_meta_box() {

		$screens = array( 'slider');

		foreach ( $screens as $screen ) {

			add_meta_box(
				'nanotheme_sectionid',
				__( 'Slider Options', 'nanotheme_textdomain' ),
				'slider_meta_box_callback',
				$screen
			);
		}
	}
	add_action( 'add_meta_boxes', 'slider_add_meta_box' );

function slider_meta_box_callback( $post ) {
// Add an nonce field so we can check for it later.
		wp_nonce_field( 'slider_meta_box', 'slider_meta_box_nonce' );

		/*
		 * Use get_post_meta() to retrieve an existing value
		 * from the database and use the value for the form.
		 */
		$sliderbtntext1 = get_post_meta( $post->ID, '_sliderbtntext1', true );
		$sliderbtnlink1 = get_post_meta( $post->ID, '_sliderbtnlink1', true );
		$sliderbtntext2 = get_post_meta( $post->ID, '_sliderbtntext2', true );
		$sliderbtnlink2 = get_post_meta( $post->ID, '_sliderbtnlink2', true );
		$slidervideo = get_post_meta( $post->ID, '_slidervideo', true );



		$rendHtml = '';
		$rendHtml .= '<div class="inside">';
		$rendHtml .= '<table style="width:100%" cellpadding="5">';
		$rendHtml .= '<tr>';
		$rendHtml .= '<td><label for="_sliderbtntext1" style="float: left; width: 150px;">First Button Text:</label><br><input type="text" value="'.$sliderbtntext1.'" class="code" id="_sliderbtntext1" name="_sliderbtntext1" style="width:100%"></td>';
		$rendHtml .= '<td><label for="_sliderbtnlink1" style="float: left; width: 150px;">First Button Link:</label><br><input type="text" value="'.$sliderbtnlink1.'" class="code" id="_sliderbtnlink1" name="_sliderbtnlink1" style="width:100%"></td>';
		$rendHtml .= '</tr>';
    
		$rendHtml .= '<tr>';
		$rendHtml .= '<td><label for="_sliderbtntext2" style="float: left; width: 150px;">Second Button Text:</label><br><input type="text" value="'.$sliderbtntext2.'" class="code" id="_sliderbtntext2" name="_sliderbtntext2" style="width:100%"></td>';
		$rendHtml .= '<td><label for="_sliderbtnlink2" style="float: left; width: 150px;">Second Button Link:</label><br><input type="text" value="'.$sliderbtnlink2.'" class="code" id="_sliderbtnlink2" name="_sliderbtnlink2" style="width:100%"></td>';
		$rendHtml .= '</tr>';
    
		$rendHtml .= '<tr>';
		$rendHtml .= '<td colspan="2"><label for="_slidervideo" style="float: left; width: 150px;">Slider Video:</label><br><input type="text" value="'.$slidervideo.'" class="code" id="_slidervideo" name="_slidervideo" style="width:100%"><p><i>Add Toutube or Vimeo video link (eg: YOUTUBE <b>https://www.youtube.com/embed/eunywT8xzDw</b> or VIMEO <b>https://player.vimeo.com/video/191602887</b> )</i></p></td>';
		$rendHtml .= '</tr>';
		$rendHtml .= '</table>';
		$rendHtml .= '</div>';

		echo $rendHtml;

	}




		function slider_save_meta_box_data( $post_id ) {

		/*
		 * We need to verify this came from our screen and with proper authorization,
		 * because the save_post action can be triggered at other times.
		 */

		// Check if our nonce is set.
		if ( ! isset( $_POST['slider_meta_box_nonce'] ) ) {
			return;
		}

		// Verify that the nonce is valid.
		if ( ! wp_verify_nonce( $_POST['slider_meta_box_nonce'], 'slider_meta_box' ) ) {
			return;
		}

		// If this is an autosave, our form has not been submitted, so we don't want to do anything.
		if ( defined( 'DOING_AUTOSAVE' ) && DOING_AUTOSAVE ) {
			return;
		}

		// Check the user's permissions.
		if ( isset( $_POST['post_type'] ) && 'page' == $_POST['post_type'] ) {

			if ( ! current_user_can( 'edit_page', $post_id ) ) {
				return;
			}

		} else {

			if ( ! current_user_can( 'edit_post', $post_id ) ) {
				return;
			}
		}



		$errorMsg = '';
			$sliderbtntext1 = sanitize_text_field( @$_POST['_sliderbtntext1'] );
			update_post_meta( $post_id, '_sliderbtntext1', $sliderbtntext1 );
			$sliderbtnlink1 = sanitize_text_field( @$_POST['_sliderbtnlink1'] );
			update_post_meta( $post_id, '_sliderbtnlink1', $sliderbtnlink1 );
			$sliderbtntext2 = sanitize_text_field( @$_POST['_sliderbtntext2'] );
			update_post_meta( $post_id, '_sliderbtntext2', $sliderbtntext2 );
			$sliderbtnlink2 = sanitize_text_field( @$_POST['_sliderbtnlink2'] );
			update_post_meta( $post_id, '_sliderbtnlink2', $sliderbtnlink2 );
			$slidervideo = sanitize_text_field( @$_POST['_slidervideo'] );
			update_post_meta( $post_id, '_slidervideo', $slidervideo );



		// redirect to same post after update edit
		if ( 'slider' == get_post_type() ) {

		/* Custom code for 'slider' post type. */

			if ( isset( $_POST['save'] ) || isset( $_POST['publish'] ) )
				return admin_url( "edit.php?post_type=slider" );

		}

		// Update the meta field in the database.
	}
	add_action( 'save_post', 'slider_save_meta_box_data' );



function arphabet_widgets_init() {

	register_sidebar( array(
		'name'          => 'Footer 3',
		'id'            => 'footer_about',
		'before_widget' => '<div class="custom-widget">',
		'after_widget'  => '</div>',
		'before_title'  => '<h2 class="widget-title">',
		'after_title'   => '</h2>',
	) );
	
	
	
	
	register_sidebar( array(
		'name'          => 'Legal-services-menu',
		'id'            => 'legal-services',
		'before_widget' => '<div class="custom-widget">',
		'after_widget'  => '</div>',
		'before_title'  => '<h2 class="widget-title">',
		'after_title'   => '</h2>',
	) );

	
		register_sidebar( array(
		'name'          => 'Industry Verticals',
		'id'            => 'industry-Verticals',
		'before_widget' => '<div class="custom-widget ts">',
		'after_widget'  => '</div>',
		'before_title'  => '<h2 class="widget-title">',
		'after_title'   => '</h2>',
	) );

	 
	 
	 register_sidebar( array(
		'name'          => 'Solutions-services',
		'id'            => 'solutionsfooter',
		'before_widget' => '<div class="custom-widget solu">',
		'after_widget'  => '</div>',
		'before_title'  => '<h2 class="widget-title">',
		'after_title'   => '</h2>',
	) );
	 
	
}
add_action( 'widgets_init', 'arphabet_widgets_init' );

function arphabett_widgets_init() {

	register_sidebar( array(
		'name'          => 'Footer call to action',
		'id'            => 'featured_clients',
		'before_widget' => '<div class="custom-widget>',
		'after_widget'  => '</div>',
		'before_title'  => '<h2 class="widget-title">',
		'after_title'   => '</h2>',
	) );

}
add_action( 'widgets_init', 'arphabett_widgets_init' );





/*******************************

  THEME OPTIONS PAGE

********************************/


add_action( 'admin_init', 'theme_options_init' );
add_action( 'admin_menu', 'theme_options_add_page' );

function theme_options_init(){
	register_setting( 'mandyoptions', 'mandytheme_options');
}

function theme_options_add_page() {
	add_theme_page( __( 'Theme Options', 'mandytheme' ), __( 'Theme Options', 'mandytheme' ), 'edit_theme_options', 'theme_options', 'theme_options_do_page' );
}
function theme_options_do_page() { global $select_options; if ( ! isset( $_REQUEST['settings-updated'] ) ) $_REQUEST['settings-updated'] = false;
?>
    <div>
        <link rel="stylesheet" type="text/css" href="<?php echo get_stylesheet_directory_uri(); ?>/assets/admin/css/font-awesome.min.css" />
        <link rel="stylesheet" type="text/css" href="<?php echo get_stylesheet_directory_uri(); ?>/assets/admin/css/animate.min.css " />
        <link rel="stylesheet" type="text/css" href="<?php echo get_stylesheet_directory_uri(); ?>/assets/admin/css/admin.css" />
        <script type="text/javascript" src="<?php echo get_stylesheet_directory_uri(); ?>/assets/admin/js/easyResponsiveTabs.js"></script>
        <script type="text/javascript" src="<?php echo get_stylesheet_directory_uri(); ?>/assets/admin/js/jquery.nicescroll.min.js"></script>
        <script type="text/javascript" src="<?php echo get_stylesheet_directory_uri(); ?>/assets/admin/js/tabs.js"></script>
        <script>
            jQuery(document).ready(function ($) {
                $('.custom_media_upload').click(function () {
                    var send_attachment_bkp = wp.media.editor.send.attachment;
                    var button = $(this);
                    wp.media.editor.send.attachment = function (props, attachment) {
                        $(button).prev().prev().attr('src', attachment.url);
                        $(button).prev().val(attachment.url);
                        wp.media.editor.send.attachment = send_attachment_bkp;
                    }
                    wp.media.editor.open(button);
                    return false;
                });
            });
        </script>
        <?php
	if(function_exists( 'wp_enqueue_media' )){
		wp_enqueue_media();
	}else{
		wp_enqueue_style('thickbox');
		wp_enqueue_script('media-upload');
		wp_enqueue_script('thickbox');
	}
?>
            <?php screen_icon(); echo "<h1>". __( 'Mandy Theme Options', 'mandytheme' ) . "</h1>"; ?>
                <?php if ( false !== $_REQUEST['settings-updated'] ) : ?>
                    <div class="settings-updated">
                        <p><strong><?php _e( 'Options saved', 'mandytheme' ); ?></strong></p>
                    </div>
                    <?php endif; ?>
                        <form method="post" action="options.php">
                            <?php settings_fields( 'mandyoptions' ); ?>
                                <?php $options = get_option( 'mandytheme_options' ); ?>
                                    <div class="VerticalTab VerticalTab_hash_scroll VerticalTab_6 tabs_ver_6">
                                        <ul class="resp-tabs-list hor_1">
                                            <li class="tabs-1" data-tab-name="general-setting"><i class="fc_icons fa fa-tasks"></i> <span class="tabs-text">General Settings</span></li>
                                            <li class="tabs-2" data-tab-name="contact-setting"><i class="fc_icons fa fa-envelope"></i> <span class="tabs-text">Contact Settings</span></li>
                                            <li class="tabs-3" data-tab-name="social-links"><i class="fc_icons fa fa-briefcase"></i> <span class="tabs-text">Social Links</span></li>
                                        </ul>
                                        <div class="resp-tabs-container hor_1">
                                            <div class="fc-tab-1">
                                                <h2 class="title_contanier">General Settings</h2>
                                                <table>
                                                    <!--<tr valign="top">
                        <th scope="row">
                            <?php //_e( 'Display Intro Paragraph', 'mandytheme' ); ?>
                        </th>
                        <td>
                            <input id="mandytheme_options[showintro]" name="mandytheme_options[showintro]" type="checkbox" value="1" />
                            <?php //checked( '1', $options['showintro'] ); ?>
                        </td>
                    </tr>-->
                                                    <tr>
                                                        <th>
                                                            <?php _e( 'Change logo', 'mandytheme' ); ?>
                                                        </th>
                                                        <td>
                                                            <input class="regular-text custom_media_url" id="mandytheme_options[logo_img]" type="text" name="mandytheme_options[logo_img]" value="<?php esc_attr_e( $options['logo_img'] ); ?>"> <a href="#" class="button custom_media_upload">Upload Logo</a> </tr>
                                                    <?php if(isset($options['logo_img'] ) && !empty($options['logo_img'])) { ?>
                                                        <tr>
                                                            <th></th>
                                                            <td align="left"><img src="<?php echo $options['logo_img'] ?>" style="background:#f2f2f2; padding:5px;" /></td>
                                                        </tr>
                                                        <?php } ?>
                                                            <tr valign="top">
                                                                <th scope="row">
                                                                    <?php _e( 'Logo ALT Text', 'mandytheme' ); ?>
                                                                </th>
                                                                <td>
                                                                    <input name="mandytheme_options[logo_alt]" type="text" id="mandytheme_options[logo_alt]" value="<?php esc_attr_e( $options['logo_alt'] ); ?>" class="regular-text" /> </td>
                                                            </tr>
                                                            <tr>
                                                                <th>
                                                                    <?php _e( 'Footer logo', 'mandytheme' ); ?>
                                                                </th>
                                                                <td>
                                                                    <input class="regular-text custom_media_url" id="mandytheme_options[footer_logo_img]" type="text" name="mandytheme_options[footer_logo_img]" value="<?php esc_attr_e( $options['footer_logo_img'] ); ?>"> <a href="#" class="button custom_media_upload">Upload Logo</a> </tr>
                                                            <?php if(isset($options['footer_logo_img'] ) && !empty($options['footer_logo_img'])) { ?>
                                                                <tr>
                                                                    <th></th>
                                                                    <td align="left"><img src="<?php echo $options['footer_logo_img'] ?>" style="background:#f2f2f2; padding:5px;" /></td>
                                                                </tr>
                                                                <?php } ?>
                                                                    <tr valign="top">
                                                                        <th scope="row">
                                                                            <?php _e( 'Footer Logo ALT Text', 'mandytheme' ); ?>
                                                                        </th>
                                                                        <td>
                                                                            <input name="mandytheme_options[logo_alt]" type="text" id="mandytheme_options[footer_logo_alt]" value="<?php esc_attr_e( $options['footer_logo_alt'] ); ?>" class="regular-text" /> </td>
                                                                    </tr>
                                                </table>
                                                <p>
                                                    <input type="submit" class="button-primary" value="<?php _e( 'Save Options', 'mandytheme' ); ?>" /> </p>
                                            </div>
                                            <div class="fc-tab-1">
                                                <h2 class="title_contanier">Contact Settings</h2>
                                                <table>
                                                    <tr valign="top">
                                                        <th scope="row">
                                                            <?php _e( 'Contact Number', 'mandytheme' ); ?>
                                                        </th>
                                                        <td>
                                                            <input id="mandytheme_options[contact_number]" type="text" name="mandytheme_options[contact_number]" value="<?php esc_attr_e( $options['contact_number'] ); ?>" class="regular-text" /> </td>
                                                    </tr>
                                                    <tr valign="top">
                                                        <th scope="row">
                                                            <?php _e( 'Contact Skype', 'mandytheme' ); ?>
                                                        </th>
                                                        <td>
                                                            <input id="mandytheme_options[contact_skype]" type="text" name="mandytheme_options[contact_skype]" value="<?php esc_attr_e( $options['contact_skype'] ); ?>" class="regular-text" /> </td>
                                                    </tr>
                                                    <tr valign="top">
                                                        <th scope="row">
                                                            <?php _e( 'Contact Email', 'mandytheme' ); ?>
                                                        </th>
                                                        <td>
                                                            <input id="mandytheme_options[contact_email]" type="text" name="mandytheme_options[contact_email]" value="<?php esc_attr_e( $options['contact_email'] ); ?>" class="regular-text" /> </td>
                                                    </tr>
                                                    <tr valign="top">
                                                        <th scope="row">
                                                            <?php _e( 'Contact Address', 'mandytheme' ); ?>
                                                        </th>
                                                        <td>
                                                            <input id="mandytheme_options[contact_address]" type="text" name="mandytheme_options[contact_address]" value="<?php esc_attr_e( $options['contact_address'] ); ?>" class="regular-text" /> </td>
                                                    </tr>
                                                </table>
                                                <p>
                                                    <input type="submit" class="button-primary" value="<?php _e( 'Save Options', 'mandytheme' ); ?>" /> </p>
                                            </div>
                                            <div class="fc-tab-1">
                                                <h2 class="title_contanier">Social Links</h2>
                                                <table>
                                                    <tr valign="top">
                                                        <th scope="row">
                                                            <?php _e( 'Facebook URL', 'mandytheme' ); ?>
                                                        </th>
                                                        <td>
                                                            <input id="mandytheme_options[facebook_link]" type="text" name="mandytheme_options[facebook_link]" value="<?php esc_attr_e($options['facebook_link']); ?>" class="regular-text" />
                                                            <label for="mandytheme_options[sometext]">
                                                                <?php _e( 'http://facebook.com/yourprofileurl', 'mandytheme' ); ?>
                                                            </label>
                                                        </td>
                                                    </tr>
                                                    <tr valign="top">
                                                        <th scope="row">
                                                            <?php _e( 'pinterest URL', 'mandytheme' ); ?>
                                                        </th>
                                                        <td>
                                                            <input id="mandytheme_options[pinterest_link]" type="text" name="mandytheme_options[pinterest_link]" value="<?php esc_attr_e($options['pinterest_link']); ?>" class="regular-text" />
                                                            <label for="mandytheme_options[sometext]">
                                                                <?php _e( 'https://in.pinterest.com/yourprofileurl', 'mandytheme' ); ?>
                                                            </label>
                                                        </td>
                                                    </tr>
                                                    <tr valign="top">
                                                        <th scope="row">
                                                            <?php _e( 'Twitter URL', 'mandytheme' ); ?>
                                                        </th>
                                                        <td>
                                                            <input id="mandytheme_options[twitter_link]" type="text" name="mandytheme_options[twitter_link]" value="<?php esc_attr_e( $options['twitter_link'] ); ?>" class="regular-text" />
                                                            <label for="mandytheme_options[sometext]">
                                                                <?php _e( 'http://twitter.com/yourprofileurl', 'mandytheme' ); ?>
                                                            </label>
                                                        </td>
                                                    </tr>
                                                    <tr valign="top">
                                                        <th scope="row">
                                                            <?php _e( 'Vimeo URL', 'mandytheme' ); ?>
                                                        </th>
                                                        <td>
                                                            <input id="mandytheme_options[vimeo_link]" type="text" name="mandytheme_options[vimeo_link]" value="<?php esc_attr_e( $options['vimeo_link'] ); ?>" class="regular-text" />
                                                            <label for="mandytheme_options[sometext]">
                                                                <?php _e( 'https://vimeo.com/yourprofileurl', 'mandytheme' ); ?>
                                                            </label>
                                                        </td>
                                                    </tr>
                                                    <tr valign="top">
                                                        <th scope="row">
                                                            <?php _e( 'Skype URL', 'mandytheme' ); ?>
                                                        </th>
                                                        <td>
                                                            <input id="mandytheme_options[skype_link]" type="text" name="mandytheme_options[skype_link]" value="<?php esc_attr_e( $options['skype_link'] ); ?>" class="regular-text" />
                                                            <label for="mandytheme_options[sometext]">
                                                                <?php _e( 'https://skype.com/yourprofileurl', 'mandytheme' ); ?>
                                                            </label>
                                                        </td>
                                                    </tr>
                                                    <tr valign="top">
                                                        <th scope="row">
                                                            <?php _e( 'Linkedin URL', 'mandytheme' ); ?>
                                                        </th>
                                                        <td>
                                                            <input id="mandytheme_options[linkedin_link]" type="text" name="mandytheme_options[linkedin_link]" value="<?php esc_attr_e( $options['linkedin_link'] ); ?>" class="regular-text" />
                                                            <label for="mandytheme_options[sometext]">
                                                                <?php _e( 'https://linkedin.com/yourprofileurl', 'mandytheme' ); ?>
                                                            </label>
                                                        </td>
                                                    </tr>
                                                    <tr valign="top">
                                                        <th scope="row">
                                                            <?php _e( 'YouTube URL', 'mandytheme' ); ?>
                                                        </th>
                                                        <td>
                                                            <input id="mandytheme_options[youtube_link]" type="text" name="mandytheme_options[youtube_link]" value="<?php esc_attr_e( $options['youtube_link'] ); ?>" class="regular-text" />
                                                            <label for="mandytheme_options[sometext]">
                                                                <?php _e( 'http://youtube.com/yourprofileurl', 'mandytheme' ); ?>
                                                            </label>
                                                        </td>
                                                    </tr>
                                                    <tr valign="top">
                                                        <th scope="row">
                                                            <?php _e( 'Instagram URL', 'mandytheme' ); ?>
                                                        </th>
                                                        <td>
                                                            <input id="mandytheme_options[instagram_link]" type="text" name="mandytheme_options[instagram_link]" value="<?php esc_attr_e( $options['instagram_link'] ); ?>" class="regular-text" />
                                                            <label for="mandytheme_options[sometext]">
                                                                <?php _e( 'http://instagram.com/yourprofileurl', 'mandytheme' ); ?>
                                                            </label>
                                                        </td>
                                                    </tr>
                                                    <tr valign="top">
                                                        <th scope="row">
                                                            <?php _e( 'Google Plus URL', 'mandytheme' ); ?>
                                                        </th>
                                                        <td>
                                                            <input id="mandytheme_options[gplus_link]" type="text" name="mandytheme_options[gplus_link]" value="<?php esc_attr_e( $options['gplus_link'] ); ?>" class="regular-text" />
                                                            <label for="mandytheme_options[sometext]">
                                                                <?php _e( 'http://google.com/yourprofileurl', 'mandytheme' ); ?>
                                                            </label>
                                                        </td>
                                                    </tr>
                                                </table>
                                                <p>
                                                    <input type="submit" class="button-primary" value="<?php _e( 'Save Options', 'mandytheme' ); ?>" /> </p>
                                            </div>
                                        </div>
                        </form>
                        </div>
                        <?php }
add_filter('sod_ajax_layered_nav_containers', 'aln_add_custom_container');
function aln_add_custom_container($containers){
$containers[] = '#product-filter';
$containers[] = '.banner-filter-form';
return $containers;
}

add_filter('sod_ajax_layered_nav_product_container', 'aln_product_container');
function aln_product_container($product_container){
//Enter either the class or id of the container that holds your products
return '.banner-filter-form';
}
/* add_filter( 'woocommerce_product_tabs', 'woo_remove_product_tabs', 98 );
function woo_remove_product_tabs( $tabs ) {
 
    unset( $tabs['additional_information'] );   // Remove the additional information tab
 
    return $tabs;
} */



add_filter( 'woocommerce_product_tabs', 'woo_rename_tab', 98);
function woo_rename_tab($tabs) {
$tabs['description']['title'] = 'Details';
$tabs['additional_information']['title'] = 'Options';
return $tabs;
} 

add_filter( 'woocommerce_product_tabs', 'new_product_tab' );

function new_product_tab( $tabs ) {
	/* Adds the new tab */
	$tabs['test_tab'] = array(
		'title' 	=> __( 'More Information', 'woocommerce' ),
		'priority' 	=> 50,  
		'callback' 	=> 'new_product_tab_content'
	);
	return $tabs;  /* Return all  tabs including the new New Custom Product Tab  to display */
}

function new_product_tab_content() {
	/* The new tab content */?>
                            <div class="more-info-sec">
                                <h5>#<?php global $product; echo $product->get_sku(); ?> 
				
				<?php
				$model_year_values = get_the_terms( $product->id, 'pa_brand');
				foreach ( $model_year_values as $model_year_value ) {
				   echo $model_year_value->name;} ?>
				<?php
				$miles_values = get_the_terms( $product->id, 'pa_model');
				foreach ( $miles_values as $miles_value ) { echo $miles_value->name;} ?>
				<?php
				$model_year_values = get_the_terms( $product->id, 'pa_model-year');
				foreach ( $model_year_values as $model_year_value ) {
				   echo $model_year_value->name;} ?> 
				</h5>
                                <?php echo do_shortcode('[contact-form-7 id="66" title="Ques Form"]');?>
                            </div>
                            <?php
}

remove_action( 'woocommerce_single_product_summary', 'woocommerce_template_single_add_to_cart', 30 );

function artical_func( ) {
	
	$args = array(
   'posts_per_page' => 3,
   'orderby' => 'date',
   'order' => 'DESC',
   'post_type'   => 'post'
);
 $new_query = new WP_Query ($args);
    if ($new_query->have_posts()) {
        while($new_query->have_posts()){
			$new_query->the_post();?>
                                <div class="  col-sm-4 col-md-4 col-xs-12">
                                    <article class="blog-news-col">
                                        <div class="blog-image">
                                            <?php if ( has_post_thumbnail()) { ?>
                                                <a href="<?php the_permalink(); ?>">
                                                    <?php  the_post_thumbnail('large'); ?>
                                                </a>
                                                <?php } else { ?> <a href="<?php the_permalink(); ?>">
			  <img src="<?php echo get_stylesheet_directory_uri();?>/images/blog-img.jpg" alt="<?php the_title(); ?>"></a>
                                                    <?php }  ?>
                                        </div>
                                        <div class="content-box">
                                            <div class="post-header">
                                                <h2 class="sub-heading"><a  href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h2>
                                                <ul class="post-info clearfix">
                                                    <li class="post-author"><i class="fa fa-users"></i> <span><?php the_author(); ?></span> </li>
                                                    <li class="blog-cat"><i class="fa fa-calendar-o"></i>
                                                        <div class="date">
                                                            <?php the_time('d') ?> <span class="month"><?php the_time('M') ?></span> <span class="year"> <?php the_time('Y') ?></span></div>
                                                    </li>
                                                </ul>
                                            </div>
                                            <p>
                                                <?php the_excerpt();?>
                                            </p>
                                            <div class="services-link post-services"> <a href="<?php the_permalink(); ?>" class="read-more">read more</a> </div>
                                        </div>
                                    </article>
                                </div>
                                <?php  }
    }
    wp_reset_postdata();
}
add_shortcode( 'artical', 'artical_func' );


function artical_full( ) {
	
	$args = array(
   'posts_per_page' => -1,
   'orderby' => 'date',
   'order' => 'DESC',
   'post_type'   => 'post'
);
 $new_query = new WP_Query ($args);
    if ($new_query->have_posts()) {
        while($new_query->have_posts()){
			$new_query->the_post();?>
                                    <div class="  col-sm-4 col-md-4 col-xs-12">
                                        <article class="blog-news-col">
                                            <div class="blog-image">
                                                <?php if ( has_post_thumbnail()) { ?>
                                                    <a href="<?php the_permalink(); ?>">
                                                        <?php  the_post_thumbnail('large'); ?>
                                                    </a>
                                                    <?php } else { ?> <a href="<?php the_permalink(); ?>">
			  <img src="<?php echo get_stylesheet_directory_uri();?>/images/blog-img.jpg" alt="<?php the_title(); ?>"></a>
                                                        <?php }  ?>
                                            </div>
                                            <div class="content-box">
                                                <div class="post-header">
                                                    <h2 class="sub-heading"><a  href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h2>
                                                    <ul class="post-info clearfix">
                                                        <li class="post-author"><i class="fa fa-users"></i> <span><?php the_author(); ?></span> </li>
                                                        <li class="blog-cat"><i class="fa fa-calendar-o"></i>
                                                            <div class="date">
                                                                <?php the_time('d') ?> <span class="month"><?php the_time('M') ?></span> <span class="year"> <?php the_time('Y') ?></span></div>
                                                        </li>
                                                    </ul>
                                                </div>
                                                <p>
                                                    <?php the_excerpt();?>
                                                </p> <a href="<?php the_permalink(); ?>" class="read-more">read more</a> </div>
                                        </article>
                                    </div>
                                    <?php  }
    }
    wp_reset_postdata();
}
add_shortcode( 'articalfull', 'artical_full' );


function news_func( ) {
	
	$args = array(
   'posts_per_page' => 3,
   'orderby' => 'date',
   'order' => 'DESC',
   'post_type'   => 'post',
   'category_name'  => 'news'
);
 $new_query = new WP_Query ($args);
    if ($new_query->have_posts()) {
        while($new_query->have_posts()){
			$new_query->the_post();?>
                                        <div class="  col-sm-4 col-md-4 col-xs-12">
                                            <article class="news-col">
                                                <div class="news-image">
                                                    <?php if ( has_post_thumbnail()) { ?>
                                                        <a href="<?php the_permalink(); ?>">
                                                            <?php  the_post_thumbnail('large'); ?>
                                                        </a>
                                                        <?php } else { ?> <a href="<?php the_permalink(); ?>">
			  <img src="<?php echo get_stylesheet_directory_uri();?>/images/blog-img.jpg" alt="<?php the_title(); ?>"></a>
                                                            <?php }  ?>
                                                </div>
                                                <div class="news-content-box">
                                                    <div class="post-header">
                                                        <div class="news-date">
                                                            <?php the_time('d') ?> <span class="month"><?php the_time('M') ?></span><span class="year"><?php the_time('Y') ?></span></div>
                                                        <h2 class="sub-heading"><a  href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h2> </div>
                                                    <p>
                                                        <?php the_excerpt();?>
                                                    </p> <a href="<?php the_permalink(); ?>" class="news-read-more">read more<i class="fa fa-long-arrow-right"></i></a> </div>
                                            </article>
                                        </div>
                                        <?php  }
    }
    wp_reset_postdata();
}

add_shortcode( 'news', 'news_func' );
 

 function news_current( ) {
	
	$args = array(
   'posts_per_page' => -1,
   'orderby' => 'date',
   'order' => 'DESC',
   'post_type'   => 'post',
   'category_name'  => 'news'
);
 $new_query = new WP_Query ($args);
    if ($new_query->have_posts()) {
        while($new_query->have_posts()){
			$new_query->the_post();?>
                                            <div class="  col-sm-4 col-md-4 col-xs-12">
                                                <article class="news-col">
                                                    <div class="news-image">
                                                        <?php if ( has_post_thumbnail()) { ?>
                                                            <a href="<?php the_permalink(); ?>">
                                                                <?php  the_post_thumbnail('large'); ?>
                                                            </a>
                                                            <?php } else { ?> <a href="<?php the_permalink(); ?>">
			  <img src="<?php echo get_stylesheet_directory_uri();?>/images/blog-img.jpg" alt="<?php the_title(); ?>"></a>
                                                                <?php }  ?>
                                                    </div>
                                                    <div class="news-content-box">
                                                        <div class="post-header">
                                                            <div class="news-date">
                                                                <?php the_time('d') ?> <span class="month"><?php the_time('M') ?></span><span class="year"><?php the_time('Y') ?></span></div>
                                                            <h2 class="sub-heading"><a  href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h2> </div>
                                                        <p>
                                                            <?php the_excerpt();?>
                                                        </p> <a href="<?php the_permalink(); ?>" class="news-read-more">read more<i class="fa fa-long-arrow-right"></i></a> </div>
                                                </article>
                                            </div>
                                            <?php  }
    }
    wp_reset_postdata();
}
add_shortcode( 'newsfull', 'news_current' );
 

// Defer Javascripts
// Defer jQuery Parsing using the HTML5 defer property
if (!(is_admin() )) {
    function defer_parsing_of_js ( $url ) {
        if ( FALSE === strpos( $url, '.js' ) ) return $url;
        if ( strpos( $url, 'jquery.js' ) ) return $url;
        // return "$url' defer ";
        return "$url' defer onload='";
    }
    add_filter( 'clean_url', 'defer_parsing_of_js', 11, 1 );
}