<?php
/**
 * The header for our theme
 *
 * This is the template that displays all of the <head> section and everything up until <div id="content">
 *
 * @link https://developer.wordpress.org/themes/basics/template-files/#template-partials
 *
 * @package WordPress
 * @subpackage Twenty_Seventeen
 * @since 1.0
 * @version 1.0
 */
 
?><!DOCTYPE html>
    <html <?php language_attributes(); ?> class="no-js no-svg">

    <head>
        <meta charset="<?php bloginfo( 'charset' ); ?>">
        <meta name="viewport" content="width=device-width, initial-scale=1">
        <link rel="profile" href="http://gmpg.org/xfn/11">
		
		<meta name="keywords" content="Vserv Business Solutions, Vserv Gurugram, Vserv Mohali, Intersoft, Intersoft Data Labs, Bed Bath and Beyond India Development Centre, BBBY IDC, VServ Bed Bath and Beyond, Intersoft Data Labs Reviews, VServ Business Solutions Reviews, Vserv Reviews, Intersoft Reviews, Digital Transformation Services, Custom Software Development, Full Lifecycle Software Testing, End To End Mobility Solutions, Real Time Machine Learning Applications, Data Analytics Tools and Techniques, Managed Cloud Services, Enterprise Service Bus, Rule Engine” />
		
		<!--[if IE 11]>
	<link rel="stylesheet" type="text/css" href="<?php echo get_template_directory_uri(); ?>/internet.css" />
<![endif]-->
		
		
        <?php wp_head(); ?>
		
		<!-- Global site tag (gtag.js) - Google Analytics -->

<script async src="https://www.googletagmanager.com/gtag/js?id=UA-128750127-1"></script>

<script>

  window.dataLayer = window.dataLayer || [];

  function gtag(){dataLayer.push(arguments);}

  gtag('js', new Date());

 

  gtag('config', 'UA-128750127-1');
  
</script>
<script src='https://www.google.com/recaptcha/api.js?render=6LeOfYEUAAAAAO5BeYTq2AJviYJcZ7_ZzIAgJJKI'></script>

    </head>

    <body <?php body_class(); ?>>
        <?php $options = get_option( 'mandytheme_options' ); ?>

            <!-- toparea -->
			<!--<header data-wow-delay="0.5s" class="wow fadeInDown top__element site-header" id="header masthead">	-->
			<header class="site-header" id="header masthead">	
                       <div class="container">
                    <div class="top-header">
                        <div class="container">
                            <ul class="header-social">
                                <?php if(isset($options['contact_number'] ) && !empty($options['contact_number'])) { ?>
                                    <li>
                                        <a href="tel:<?php echo $options['contact_number_tel'] ?>" target="_blank"> <i class="fa fa-phone"> </i>
                                            <?php echo $options['contact_number'] ?>
                                        </a>
                                    </li>
                                    <?php } ?>
                                        <?php if(isset($options['contact_number2'] ) && !empty($options['contact_number2'])) { ?>
                                            <li>
                                                <a href="whatsapp://send?text=Hello%20Domiyance%20&phone=+918283063333<?php echo $options['contact_number_tel2'] ?>" target="_blank"> <i class="fa fa-phone"> </i>
                                                    <?php echo $options['contact_number2'] ?>
                                                </a>
                                            </li>
                                            <?php } ?>
                                                <?php if(isset($options['contact_skype'] ) && !empty($options['contact_skype'])) { ?>
                                                    <li>
                                                        <a href="skype:<?php echo $options['contact_skype'] ?>?chat" target="_blank">
                                                            <?php echo $options['contact_skype'] ?>
                                                        </a>
                                                    </li>
                                                    <?php } ?>
                            </ul>
                        </div>
                    </div>

                    <div class="main_header">
                        <div class="container">
                            <div class="row">
                                <div class="site-logo col-sm-2">
                                    <a href="<?php echo esc_url( home_url( '/' ) ); ?>" rel="home">
                                        <?php if(isset($options['logo_img'] ) && !empty($options['logo_img'])) { ?> <img src="<?php echo $options['logo_img'] ?>" alt="<?php bloginfo( 'name' ); ?>" />
                                            <?php } else { ?> <img src="<?php echo get_stylesheet_directory_uri();?>/assets/images/logo.png" alt="<?php bloginfo( 'name' ); ?>">
                                                <?php } ?>
                                    </a>
                                </div>
                                <div class="top-area col-sm-10">
                                    <div class="main_navigation">
                                        <?php if ( has_nav_menu( 'top' ) ) : ?>
                                            <?php get_template_part( 'template-parts/navigation/navigation', 'top' ); ?>
                                                <?php endif; ?>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <?php //get_template_part( 'template-parts/header/header', 'image' ); ?>
                </div>
                </div>
            </header>
            <!-- #masthead -->

            <?php if (has_post_thumbnail( $post->ID ) ): ?>
                <?php $image = wp_get_attachment_image_src( get_post_thumbnail_id( $post->ID ), 'single-post-thumbnail' ); ?>
                    <style>
                        .page-banner {
                            background-image: url(<?php echo $image[0]; ?>);
                        }
                    </style>
                    <?php endif; ?>
                        <div class="page-banner">
                            <div class="container">
                                <h1>
				<?php single_post_title(); ?>
			</h1>
                            </div>
                        </div>
                        <div class="clearfix"></div>

                        <div id="content" class="site-content">