/**
 * WonderPlugin Tabs Plugin Skin Options
 * Copyright 2015 Magic Hills Pty Ltd - http://www.wonderplugin.com
 */

var WONDERPLUGIN_TABS_SKIN_OPTIONS = {
	leftcarouseltabs: {
		usetablecellfortitle:			false,
		fixedheadersize:				false,
		fullwidthtabs:					false,
		accordion:						false,
		width: 							800,
		heightmode:						'auto',
		height: 						400,
		minheight:						400,
		triggerresize:					true,
		triggerresizeonload:			true,
		triggerresizeonloadtimeout:		100,
		disablewpautop:					false,
		firstid:						0,
		extendedheight:					false,
		responsive:						true,
		fullwidth:						false,
		direction:						'vertical',
		tabposition:					'left',
		tabiconposition:				'left',
		horizontaltabalign:				'left',
		fullwidthtabsonsmallscreen:		true,
		accordiononsmallscreen:			true,
		fullwidthtabsonsmallscreenwidth:480,
		hidetitleonsmallscreen:			false,
		hidetitleonsmallscreenwidth: 	768,
		responsivemode:					'arrow',
		tabarrowmode:					'slide',
		horizontalarrowwidthsameasheight:'pixels',
		horizontalarrowwidth:			32,
		arrowprevicon:					'fa-chevron-circle-up',
		arrownexticon:					'fa-chevron-circle-down',
		arrowfontsize:					20,
		arrowfontcolor:					'#666',
		dropdownmenutext:				'More',
		dropdownmenuicon:				'fa-angle-right',
		skinoptions:					'{"title-color" : ["color", "#333", "Title color"], "icon-color" : ["color", "#666", "FontAwesome icon color"], "icon-size" : ["pixel", "16", "Fontawesome icon size"], "tab-radius" : ["pixel", "4", "Tab border radius"], "tab-margin" : ["pixel", "4", "Tab margin"], "panel-padding" : ["pixel", "24", "Panel padding"], "panel-text-align" : ["align", "left", "Panel text align"] }',
		skincss:						'@import url(\'https://fonts.googleapis.com/css?family=Open+Sans:400,300,600\');\n\n#wonderplugintabs-TABSID > .wonderplugintabs-header-wrap {\n	box-sizing: border-box;\n	display: block;\n	position: relative;\n	z-index: 1;\n	float: left;\n}\n\n#wonderplugintabs-TABSID > .wonderplugintabs-header-wrap .wonderplugintabs-header-inner-wrap {\n	box-sizing: border-box;\n	display: block;\n	height: 100%;\n	overflow: hidden;	\n}\n\n#wonderplugintabs-TABSID > .wonderplugintabs-header-wrap .wonderplugintabs-header-inner-wrap-arrows {\n	padding-top: @tab-margin;\n}\n\n#wonderplugintabs-TABSID > .wonderplugintabs-header-wrap .wonderplugintabs-header-ul {\n	box-sizing: border-box;\n	display: block;\n	position: relative;\n	list-style: none;\n	margin: 0;\n	padding: 0;\n}\n\n#wonderplugintabs-TABSID > .wonderplugintabs-header-wrap .wonderplugintabs-header-caption {\n	cursor: pointer;\n	padding: 8px 12px;\n}\n\n#wonderplugintabs-TABSID > .wonderplugintabs-header-wrap .wonderplugintabs-header-li {\n	box-sizing: border-box;\n	display: block;\n	position: relative;\n	text-align: left;\n	margin: 0 0 @tab-margin 0;\n	padding: 0px;\n	background-color: #f6f6f6;\n	border: 1px solid #ccc;\n	border-radius: @tab-radius;\n}\n\n#wonderplugintabs-TABSID > .wonderplugintabs-header-wrap .wonderplugintabs-header-li-next {\n	border-left: 1px solid #ccc;\n}\n\n#wonderplugintabs-TABSID > .wonderplugintabs-header-wrap .wonderplugintabs-header-li:hover {\n	background-color: #fff;\n}\n\n#wonderplugintabs-TABSID > .wonderplugintabs-header-wrap .wonderplugintabs-header-li-active {\n	background-color: #fff;\n}\n\n#wonderplugintabs-TABSID > .wonderplugintabs-header-wrap .wonderplugintabs-header-li-active-last {\n}\n\n#wonderplugintabs-TABSID > .wonderplugintabs-header-wrap .wonderplugintabs-header-li-first {\n}\n\n#wonderplugintabs-TABSID > .wonderplugintabs-header-wrap .wonderplugintabs-header-li-first-side-arrows {\n}\n\n#wonderplugintabs-TABSID > .wonderplugintabs-header-wrap .wonderplugintabs-header-li-last {\n}\n\n#wonderplugintabs-TABSID > .wonderplugintabs-header-wrap .wonderplugintabs-header-li-last-side-arrows {\n}\n\n#wonderplugintabs-TABSID > .wonderplugintabs-header-wrap .wonderplugintabs-header-prev {\n	display: none;\n	text-align: center;\n	position: absolute;\n	top: 0;\n	left: 0;\n	width: 100%;\n	cursor: pointer;\n	height: 40px;\n	z-index: 1;\n}\n\n#wonderplugintabs-TABSID > .wonderplugintabs-header-wrap .wonderplugintabs-header-prev:before {\n	position: relative;\n	top: 50%;\n	margin-top: -9px;\n	font-family: FontAwesome;\n	display: block;\n}\n\n#wonderplugintabs-TABSID > .wonderplugintabs-header-wrap .wonderplugintabs-header-prev:hover {\n}\n\n#wonderplugintabs-TABSID > .wonderplugintabs-header-wrap .wonderplugintabs-header-next {\n	display: none;\n	text-align: center;\n	position: absolute;\n	bottom: 0;\n	left: 0;\n	width: 100%;\n	cursor:pointer;\n	height: 40px;\n	z-index: 1;\n}\n\n#wonderplugintabs-TABSID > .wonderplugintabs-header-wrap .wonderplugintabs-header-next:before {\n	position: relative;\n	top: 50%;\n	margin-top: -9px;\n	font-family: FontAwesome;\n	display: block;\n}\n\n#wonderplugintabs-TABSID > .wonderplugintabs-header-wrap .wonderplugintabs-header-next:hover {\n}\n\n#wonderplugintabs-TABSID > .wonderplugintabs-header-wrap .wonderplugintabs-header-menu {\n	box-sizing: border-box;\n	display: none;\n	text-align: center;\n	position: absolute;\n	bottom: 0;\n	left: 0;\n	cursor: pointer;\n	width: 100%;\n	background-color: #f6f6f6;\n	border: 1px solid #ccc;\n	border-top-left-radius: @tab-radius;\n	border-bottom-left-radius: @tab-radius;\n	padding: 8px 12px;\n}\n\n#wonderplugintabs-TABSID > .wonderplugintabs-header-wrap .wonderplugintabs-header-menu-caption {\n	display: table-cell;\n	vertical-align: middle;\n}\n\n#wonderplugintabs-TABSID > .wonderplugintabs-header-wrap .wonderplugintabs-header-menu-text {\n	font-family: \"Open Sans\", Arial, sans-serif;\n	font-size: 12px;\n	font-weight: 400;\n	vertical-align: middle;\n	color: @title-color;\n}\n\n#wonderplugintabs-TABSID > .wonderplugintabs-header-wrap .wonderplugintabs-header-menu-icon {\n	font-family: FontAwesome;\n	font-size: 14px;\n	vertical-align: middle;\n	margin: 8px;\n	color: @icon-color;\n}\n\n#wonderplugintabs-TABSID > .wonderplugintabs-header-wrap .wonderplugintabs-header-menu:hover {\n	background-color: #fff;	\n}\n\n#wonderplugintabs-TABSID > .wonderplugintabs-header-wrap .wonderplugintabs-header-menu-dropdown {\n	box-sizing: border-box;\n	display: none;\n	position: absolute;\n	white-space: nowrap;\n	bottom: 0;\n	left: 100%;	\n	border-top: 1px solid #ccc;\n	border-right: 1px solid #ccc;\n	border-bottom: 1px solid #ccc;\n	box-shadow: 0 6px 12px rgba(0,0,0,.175);\n}\n\n#wonderplugintabs-TABSID > .wonderplugintabs-header-wrap .wonderplugintabs-header-menu-dropdown-item {\n	padding: 12px 32px 12px 20px;	\n	cursor: pointer;\n	text-align: left;\n	background-color: #fff;\n}\n\n#wonderplugintabs-TABSID > .wonderplugintabs-header-wrap .wonderplugintabs-header-menu-dropdown-item:hover {\n	background-color: #f9f9f9;	\n}\n\n#wonderplugintabs-TABSID > .wonderplugintabs-header-wrap .wonderplugintabs-header-icon-fontawesome {\n	font-family: FontAwesome;\n	line-height: @icon-size;\n	font-size: @icon-size;\n	vertical-align: middle;\n	margin: 8px;\n	color: @icon-color;\n}\n\n#wonderplugintabs-TABSID > .wonderplugintabs-header-wrap .wonderplugintabs-header-icon-image {\n	margin: 4px;\n	vertical-align: middle;\n}\n\n#wonderplugintabs-TABSID > .wonderplugintabs-header-wrap .wonderplugintabs-header-title {\n	display: inline-block;\n	margin: 4px;\n	font-family: \"Open Sans\", Arial, sans-serif;\n	font-size: 12px;\n	font-weight: 400;\n	vertical-align: middle;\n	color: @title-color;\n	white-space: nowrap;\n}\n\n#wonderplugintabs-TABSID > .wonderplugintabs-header-wrap-fullwidth {\n	float: none;\n}\n\n#wonderplugintabs-TABSID > .wonderplugintabs-panel-wrap-fullwidth {\n	left: 0;\n}\n\n#wonderplugintabs-TABSID > .wonderplugintabs-header-wrap .wonderplugintabs-header-li-fullwidth {\n	display: block;\n	margin: 0;\n	border: 1px solid #ccc;\n	border-bottom: none;\n	text-align: left;\n	border-top-left-radius: 4px;\n	border-top-right-radius: 4px;\n	border-bottom-left-radius: 0px;\n	border-bottom-right-radius: 0px;\n}\n\n#wonderplugintabs-TABSID > .wonderplugintabs-panel-wrap {\n	box-sizing: border-box;\n	position: relative;\n	display: block;\n	overflow: hidden;\n	border: 1px solid #ccc;\n	background-color: #fff;	\n	left: 4px;\n}\n\n#wonderplugintabs-TABSID > .wonderplugintabs-panel-wrap > .wonderplugintabs-panel {\n	box-sizing: border-box;\n	display: block;\n	visibility: hidden;\n	position: absolute;\n	top: 0;\n	left: 0;\n	width: 100%;\n	text-align: @panel-text-align;\n	padding: @panel-padding;\n}\n\n#wonderplugintabs-TABSID > .wonderplugintabs-panel-wrap > .wonderplugintabs-panel-active {\n	position: relative;\n}\n\n#wonderplugintabs-TABSID > .wonderplugintabs-header-wrap .wonderplugintabs-header-ul-fullwidth {\n	white-space: normal;\n}\n\n#wonderplugintabs-TABSID > .wonderplugintabs-header-wrap .wonderplugintabs-header-li-fullwidth {\n	border-radius: 0;\n}\n\n#wonderplugintabs-TABSID > .wonderplugintabs-header-wrap  .wonderplugintabs-panel {\n	padding: @panel-padding;\n	text-align: @panel-text-align;\n}\n\n#wonderplugintabs-TABSID > .wonderplugintabs-header-wrap  .wonderplugintabs-panel-active {\n	position: relative;\n}\n\n#wonderplugintabs-TABSID > .wonderplugintabs-header-wrap .wonderplugintabs-header-li-fullwidth .wonderplugintabs-header-caption:after {\n	position:absolute;\n	color:@title-color;\n	top: 12px;\n	right:8px;\n	content: \"\\f107\";\n	font-family: FontAwesome;\n	font-size: 16px;\n	font-weight:400;\n}\n\n#wonderplugintabs-TABSID > .wonderplugintabs-header-wrap .wonderplugintabs-header-li-fullwidth.wonderplugintabs-header-li-active .wonderplugintabs-header-caption:after {\n	content: \"\\f106\";\n}'
	},
	topcarouseltabs: {
		usetablecellfortitle:			false,
		fixedheadersize:				true,
		fullwidthtabs:					false,
		accordion:						false,
		width: 							800,
		heightmode:						'auto',
		height: 						400,
		minheight:						300,
		triggerresize:					true,
		triggerresizeonload:			true,
		triggerresizeonloadtimeout:		100,
		disablewpautop:					false,
		firstid:						0,
		extendedheight:					false,
		responsive:						true,
		fullwidth:						false,
		direction:						'horizontal',
		tabposition:					'top',
		tabiconposition:				'top',
		horizontaltabalign:				'center',
		fullwidthtabsonsmallscreen:		false,
		accordiononsmallscreen:			false,
		fullwidthtabsonsmallscreenwidth:480,
		hidetitleonsmallscreen:			false,
		hidetitleonsmallscreenwidth: 	768,
		responsivemode:					'arrow',
		tabarrowmode:					'switch',
		horizontalarrowwidthsameasheight:'pixels',
		horizontalarrowwidth:			60,
		arrowprevicon:					'fa-chevron-left',
		arrownexticon:					'fa-chevron-right',
		arrowfontsize:					20,
		arrowfontcolor:					'#666',
		dropdownmenutext:				'More',
		dropdownmenuicon:				'fa-angle-down',
		skinoptions:					'{"tab-color" : ["color", "#f6f6f6", "Title color"], "tab-active-color" : ["color", "#fff", "Title active color"], "title-color" : ["color", "#333", "Title color"], "title-active-color" : ["color", "#333", "Title active color"], "icon-color" : ["color", "#666", "FontAwesome icon color"], "icon-active-color" : ["color", "#666", "Active FontAwesome icon color"], "icon-size" : ["pixel", "18", "Fontawesome icon size"], "tab-margin" : ["pixel", "4", "Tab margin"], "panel-padding" : ["pixel", "24", "Panel padding"], "panel-text-align" : ["align", "left", "Panel text align"] }',
		skincss:						'@import url(\'https://fonts.googleapis.com/css?family=Open+Sans:400,300,600\');\n\n#wonderplugintabs-TABSID > .wonderplugintabs-header-wrap {\n	box-sizing: border-box;\n	display: block;\n	position: relative;\n	width: 100%;	\n	z-index: 1;\n}\n\n#wonderplugintabs-TABSID > .wonderplugintabs-header-wrap .wonderplugintabs-header-inner-wrap {\n	box-sizing: border-box;\n	display: block;\n	overflow: hidden;	\n	padding: 8px 0;\n}\n\n#wonderplugintabs-TABSID > .wonderplugintabs-header-wrap .wonderplugintabs-header-ul {\n	box-sizing: border-box;\n	display: block;\n	position: relative;\n	list-style: none;\n	white-space: nowrap;\n	margin: 0;\n	padding: 0;\n}\n\n#wonderplugintabs-TABSID > .wonderplugintabs-header-wrap .wonderplugintabs-header-caption {\n	cursor: pointer;\n	padding: 8px;\n	white-space: normal;\n}\n\n#wonderplugintabs-TABSID > .wonderplugintabs-header-wrap .wonderplugintabs-header-li {\n	box-sizing: border-box;\n	display: inline-block;\n	position: relative;\n	margin: 0 @tab-margin 0 0;\n	padding: 0;\n	vertical-align: middle;\n	background-color: @tab-color;\n	border-radius: 8px;\n	box-shadow: 0px 1px 2px #aaa;\n}\n\n#wonderplugintabs-TABSID > .wonderplugintabs-header-wrap .wonderplugintabs-header-li-next {\n}\n\n#wonderplugintabs-TABSID > .wonderplugintabs-header-wrap .wonderplugintabs-header-li:hover {\n	background-color: @tab-active-color;\n}\n\n#wonderplugintabs-TABSID > .wonderplugintabs-header-wrap .wonderplugintabs-header-li-active {\n	background-color: @tab-active-color;\n}\n\n#wonderplugintabs-TABSID > .wonderplugintabs-header-wrap .wonderplugintabs-header-li-active-last {\n}\n\n#wonderplugintabs-TABSID > .wonderplugintabs-header-wrap .wonderplugintabs-header-li-first {\n}\n\n#wonderplugintabs-TABSID > .wonderplugintabs-header-wrap .wonderplugintabs-header-li-first-side-arrows {\n	margin-left: @tab-margin;\n}\n\n#wonderplugintabs-TABSID > .wonderplugintabs-header-wrap .wonderplugintabs-header-li-last {\n}\n\n#wonderplugintabs-TABSID > .wonderplugintabs-header-wrap .wonderplugintabs-header-li-last-side-arrows {\n}\n\n#wonderplugintabs-TABSID > .wonderplugintabs-header-wrap .wonderplugintabs-header-prev {\n	display: none;\n	text-align: center;\n	position: absolute;\n	top: 0;\n	left: 0;\n	cursor: pointer;\n	margin: 8px 0;\n}\n\n#wonderplugintabs-TABSID > .wonderplugintabs-header-wrap .wonderplugintabs-header-prev:before {\n	position: relative;\n	top: 50%;\n	font-family: FontAwesome;\n	margin-top: -9px;\n	display: block;\n	opacity: 0.6;\n}\n\n#wonderplugintabs-TABSID > .wonderplugintabs-header-wrap .wonderplugintabs-header-prev:hover:before {\n	opacity: 1;\n}\n\n#wonderplugintabs-TABSID > .wonderplugintabs-header-wrap .wonderplugintabs-header-next {\n	display: none;\n	text-align: center;\n	position: absolute;\n	top: 0;\n	right: 0;\n	cursor: pointer;\n	margin: 8px 0;\n}\n\n#wonderplugintabs-TABSID > .wonderplugintabs-header-wrap .wonderplugintabs-header-next:before {\n	position: relative;\n	top: 50%;\n	font-family: FontAwesome;\n	margin-top: -9px;\n	display: block;\n	opacity: 0.6;\n}\n\n#wonderplugintabs-TABSID > .wonderplugintabs-header-wrap .wonderplugintabs-header-next:hover:before {\n	opacity: 1;\n}\n\n#wonderplugintabs-TABSID > .wonderplugintabs-header-wrap .wonderplugintabs-header-menu {\n	box-sizing: border-box;\n	display: none;\n	text-align: center;\n	position: absolute;\n	top: 0;\n	right: 0;\n	cursor: pointer;\n	padding: 8px;\n}\n\n#wonderplugintabs-TABSID > .wonderplugintabs-header-wrap .wonderplugintabs-header-menu-caption {\n	display: table-cell;\n	vertical-align: middle;\n}\n\n#wonderplugintabs-TABSID > .wonderplugintabs-header-wrap .wonderplugintabs-header-menu-text {\n	font-family: \"Open Sans\", Arial, sans-serif;\n	font-size: 12px;\n	font-weight: 400;\n	vertical-align: middle;\n	color: #333;\n}\n\n#wonderplugintabs-TABSID > .wonderplugintabs-header-wrap .wonderplugintabs-header-menu-icon {\n	font-family: FontAwesome;\n	font-size: 14px;\n	vertical-align: middle;\n	margin: 8px;\n	color: #666;\n}\n\n#wonderplugintabs-TABSID > .wonderplugintabs-header-wrap .wonderplugintabs-header-menu:hover {\n	}\n\n#wonderplugintabs-TABSID > .wonderplugintabs-header-wrap .wonderplugintabs-header-menu-dropdown {\n	box-sizing: border-box;\n	display: none;\n	position: absolute;\n	white-space: nowrap;\n	top: 100%;\n	right: 0;	\n	border: 1px solid #ccc;\n	box-shadow: 0 6px 12px rgba(0,0,0,.175);\n}\n\n#wonderplugintabs-TABSID > .wonderplugintabs-header-wrap .wonderplugintabs-header-menu-dropdown-item {\n	padding: 12px 32px 12px 20px;	\n	cursor: pointer;\n	text-align: left;\n	background-color: #fff;\n}\n\n#wonderplugintabs-TABSID > .wonderplugintabs-header-wrap .wonderplugintabs-header-menu-dropdown-item:hover {\n	background-color: #f9f9f9;	\n}\n\n#wonderplugintabs-TABSID > .wonderplugintabs-header-wrap .wonderplugintabs-header-icon-fontawesome {\n	font-family: FontAwesome;\n	line-height: @icon-size;\n	font-size: @icon-size;\n	vertical-align: middle;\n	margin: 8px;\n	color: @icon-color;\n	opacity: 0.8;\n}\n\n#wonderplugintabs-TABSID > .wonderplugintabs-header-wrap .wonderplugintabs-header-li:hover .wonderplugintabs-header-icon-fontawesome,\n#wonderplugintabs-TABSID > .wonderplugintabs-header-wrap .wonderplugintabs-header-li-active .wonderplugintabs-header-icon-fontawesome {\ncolor: @icon-active-color;\n	opacity: 1;\n}\n\n#wonderplugintabs-TABSID > .wonderplugintabs-header-wrap .wonderplugintabs-header-icon-image {\n	margin: 4px;\n	vertical-align: middle;\n	opacity: 0.8;\n}\n\n#wonderplugintabs-TABSID > .wonderplugintabs-header-wrap .wonderplugintabs-header-li:hover .wonderplugintabs-header-icon-image,\n#wonderplugintabs-TABSID > .wonderplugintabs-header-wrap .wonderplugintabs-header-li-active .wonderplugintabs-header-icon-image {\n	opacity: 1;\n}\n\n#wonderplugintabs-TABSID > .wonderplugintabs-header-wrap .wonderplugintabs-header-title {\n	display: inline-block;\n	margin: 4px;\n	font-family: \"Open Sans\", Arial, sans-serif;\n	font-size: 14px;\n	font-weight: 300;\n	vertical-align: middle;\n	color: @title-color;\n}\n\n#wonderplugintabs-TABSID > .wonderplugintabs-header-wrap .wonderplugintabs-header-li:hover .wonderplugintabs-header-title,\n#wonderplugintabs-TABSID > .wonderplugintabs-header-wrap .wonderplugintabs-header-li-active .wonderplugintabs-header-title {\n	color: @title-active-color;\n}\n \n#wonderplugintabs-TABSID > .wonderplugintabs-header-wrap .wonderplugintabs-header-li-fullwidth {\n	display: block;\n	margin: 0;\n	text-align: center;\n}\n\n#wonderplugintabs-TABSID > .wonderplugintabs-panel-wrap {\n	box-sizing: border-box;\n	position: relative;\n	display: block;\n	width: 100%;\n	overflow: hidden;\n}\n\n#wonderplugintabs-TABSID > .wonderplugintabs-panel-wrap > .wonderplugintabs-panel {\n	box-sizing: border-box;\n	display: block;\n	visibility: hidden;\n	position: absolute;\n	top: 0;\n	left: 0;\n	width: 100%;\n	text-align: @panel-text-align;\n	padding: @panel-padding;\n}\n\n#wonderplugintabs-TABSID > .wonderplugintabs-panel-wrap > .wonderplugintabs-panel-active {\n	position: relative;\n}\n\n#wonderplugintabs-TABSID > .wonderplugintabs-header-wrap .wonderplugintabs-header-ul-fullwidth {\n	white-space: normal;\n}\n\n#wonderplugintabs-TABSID > .wonderplugintabs-header-wrap .wonderplugintabs-header-li-fullwidth {\n	border-radius: 0;\n}\n\n#wonderplugintabs-TABSID > .wonderplugintabs-header-wrap  .wonderplugintabs-panel {\n	padding: @panel-padding;\n	text-align: @panel-text-align;\n}\n\n#wonderplugintabs-TABSID > .wonderplugintabs-header-wrap  .wonderplugintabs-panel-active {\n	position: relative;\n}'
	},
	faqtabs: {
		usetablecellfortitle:			true,
		accordioncloseall:				true,
		fixedheadersize:				false,
		fullwidthtabs:					true,
		accordion:						true,
		width: 							800,
		heightmode:						'auto',
		height: 						400,
		minheight:						300,
		triggerresize:					true,
		triggerresizeonload:			true,
		triggerresizeonloadtimeout:		100,
		disablewpautop:					false,
		firstid:						0,
		extendedheight:					false,
		responsive:						true,
		fullwidth:						false,
		direction:						'horizontal',
		tabposition:					'top',
		tabiconposition:				'left',
		horizontaltabalign:				'left',
		fullwidthtabsonsmallscreen:		true,
		accordiononsmallscreen:			true,
		fullwidthtabsonsmallscreenwidth:480,
		hidetitleonsmallscreen:			false,
		hidetitleonsmallscreenwidth: 	768,
		responsivemode:					'menu',
		tabarrowmode:					'slide',
		horizontalarrowwidthsameasheight:'pixels',
		horizontalarrowwidth:			32,
		arrowprevicon:					'fa-angle-left',
		arrownexticon:					'fa-angle-right',
		arrowfontsize:					20,
		arrowfontcolor:					'#666',
		dropdownmenutext:				'More',
		dropdownmenuicon:				'fa-angle-down',
		skinoptions:					'{"title-color" : ["color", "#00338d", "Title color"], "border-color" : ["color", "#eae8e8", "Border color"], "icon-color" : ["color", "#00338d", "FontAwesome icon color"], "icon-size" : ["pixel", "16", "Fontawesome icon size"], "expand-icon-color" : ["color", "#666", "Expand icon color"], "tab-radius" : ["pixel", "0", "Tab border radius"], "tab-margin" : ["pixel", "8", "Tab margin"], "panel-padding" : ["pixel", "14", "Panel padding"], "panel-text-align" : ["align", "left", "Panel text align"] }',
		skincss:						'@import url(\'https://fonts.googleapis.com/css?family=Open+Sans:400,300,600\');\n\n#wonderplugintabs-TABSID > .wonderplugintabs-header-wrap {\n	box-sizing: border-box;\n	display: block;\n	position: relative;\n	width: 100%;	\n	z-index: 1;\n	margin-top: -1px;\n}\n\n#wonderplugintabs-TABSID > .wonderplugintabs-header-wrap .wonderplugintabs-header-inner-wrap {\n	box-sizing: border-box;\n	display: block;\n	overflow: hidden;	\n}\n\n#wonderplugintabs-TABSID > .wonderplugintabs-header-wrap .wonderplugintabs-header-ul {\n	box-sizing: border-box;\n	display: block;\n	position: relative;\n	list-style: none;\n	margin: 0;\n	padding: 0;\n}\n\n#wonderplugintabs-TABSID > .wonderplugintabs-header-wrap .wonderplugintabs-header-caption {\n	cursor: pointer;\n	padding: 8px;\n	border: none;\n}\n\n#wonderplugintabs-TABSID > .wonderplugintabs-header-wrap .wonderplugintabs-header-li {\n	box-sizing: border-box;\n	display: block;\n	position: relative;\n	text-align: left;\n	margin: @tab-margin 0;\n	padding: 0;\n	background-color: #f6f6f6;\n	border-bottom: 1px solid @border-color;\n	border-radius: @tab-radius;\n}\n\n#wonderplugintabs-TABSID > .wonderplugintabs-header-wrap .wonderplugintabs-header-li .wonderplugintabs-header-caption:after {\n	position:absolute;\n	color:@expand-icon-color;\n	top: 12px;\n	right:8px;\n	content: \"\\f107\";\n	font-family: FontAwesome;\n	font-size: 16px;\n	font-weight:400;\n}\n\n#wonderplugintabs-TABSID > .wonderplugintabs-header-wrap .wonderplugintabs-header-li:hover {\n	background-color: #fff;\n}\n\n#wonderplugintabs-TABSID > .wonderplugintabs-header-wrap .wonderplugintabs-header-li-active {\n	background-color: #fff;\n}\n\n#wonderplugintabs-TABSID > .wonderplugintabs-header-wrap .wonderplugintabs-header-li-active .wonderplugintabs-header-caption {\n	padding-bottom: 8px;\n	border-bottom: 1px solid #ccc;\n}\n\n#wonderplugintabs-TABSID > .wonderplugintabs-header-wrap .wonderplugintabs-header-li-active .wonderplugintabs-header-caption:after {\n	content: \"\\f106\";\n}\n\n#wonderplugintabs-TABSID > .wonderplugintabs-header-wrap .wonderplugintabs-header-icon-fontawesome {\n	font-family: FontAwesome;\n	line-height: @icon-size;\n	font-size: @icon-size;\n	vertical-align: middle;\n	margin: 8px;\n	color: @icon-color;\n}\n\n#wonderplugintabs-TABSID > .wonderplugintabs-header-wrap .wonderplugintabs-header-icon-image {\n	margin: 4px;\n	vertical-align: middle;\n}\n\n#wonderplugintabs-TABSID > .wonderplugintabs-header-wrap .wonderplugintabs-header-title {\n	display: inline-block;\n	margin: 4px;\n	font-family: \"Open Sans\", Arial, sans-serif;\n	font-size: 14px;\n	padding-right: 20px;\n	vertical-align: middle;\n	color: @title-color;\n}\n\n#wonderplugintabs-TABSID > .wonderplugintabs-header-wrap  .wonderplugintabs-panel {\n	box-sizing: border-box;\n	display: block;\n	visibility: hidden;\n	position: relative;\n	top: 0;\n	left: 0;\n	width: 100%;\n	text-align: @panel-text-align;\n	padding: @panel-padding;\n}\n'
	},
	accordiontabs: {
		usetablecellfortitle:			true,
		fixedheadersize:				false,
		fullwidthtabs:					true,
		accordion:						true,
		width: 							800,
		heightmode:						'auto',
		height: 						400,
		minheight:						300,
		triggerresize:					true,
		triggerresizeonload:			true,
		triggerresizeonloadtimeout:		100,
		disablewpautop:					false,
		firstid:						0,
		extendedheight:					false,
		responsive:						true,
		fullwidth:						false,
		direction:						'horizontal',
		tabposition:					'top',
		tabiconposition:				'left',
		horizontaltabalign:				'left',
		fullwidthtabsonsmallscreen:		true,
		accordiononsmallscreen:			true,
		fullwidthtabsonsmallscreenwidth:480,
		hidetitleonsmallscreen:			false,
		hidetitleonsmallscreenwidth: 	768,
		responsivemode:					'menu',
		tabarrowmode:					'slide',
		horizontalarrowwidthsameasheight:'pixels',
		horizontalarrowwidth:			32,
		arrowprevicon:					'fa-angle-left',
		arrownexticon:					'fa-angle-right',
		arrowfontsize:					20,
		arrowfontcolor:					'#666',
		dropdownmenutext:				'More',
		dropdownmenuicon:				'fa-angle-down',
		skinoptions:					'{"title-color" : ["color", "#cc0000", "Title color"], "border-color" : ["color", "#ccc", "Border color"], "icon-color" : ["color", "#cc0000", "FontAwesome icon color"], "icon-size" : ["pixel", "18", "Fontawesome icon size"], "expand-icon-color" : ["color", "#666", "Expand icon color"], "tab-radius" : ["pixel", "4", "Tab border radius"], "tab-margin" : ["pixel", "12", "Tab margin"], "panel-padding" : ["pixel", "14", "Panel padding"], "panel-text-align" : ["align", "left", "Panel text align"] }',
		skincss:						'@import url(\'https://fonts.googleapis.com/css?family=Open+Sans:400,300,600\');\n\n#wonderplugintabs-TABSID > .wonderplugintabs-header-wrap {\n	box-sizing: border-box;\n	display: block;\n	position: relative;\n	width: 100%;	\n	z-index: 1;\n	margin-top: -1px;\n}\n\n#wonderplugintabs-TABSID > .wonderplugintabs-header-wrap .wonderplugintabs-header-inner-wrap {\n	box-sizing: border-box;\n	display: block;\n	overflow: hidden;	\n}\n\n#wonderplugintabs-TABSID > .wonderplugintabs-header-wrap .wonderplugintabs-header-ul {\n	box-sizing: border-box;\n	display: block;\n	position: relative;\n	list-style: none;\n	margin: 0;\n	padding: 0;\n}\n\n#wonderplugintabs-TABSID > .wonderplugintabs-header-wrap .wonderplugintabs-header-caption {\n	cursor: pointer;\n	padding: 8px;\n	border: none;\n}\n\n#wonderplugintabs-TABSID > .wonderplugintabs-header-wrap .wonderplugintabs-header-li {\n	box-sizing: border-box;\n	display: block;\n	position: relative;\n	text-align: left;\n	margin: @tab-margin 0;\n	padding: 0;\n	background-color: #f6f6f6;\n	border: 1px solid @border-color;\n	border-radius: @tab-radius;\n}\n\n#wonderplugintabs-TABSID > .wonderplugintabs-header-wrap .wonderplugintabs-header-li .wonderplugintabs-header-caption:after {\n	position:absolute;\n	color:@expand-icon-color;\n	top: 12px;\n	right:8px;\n	content: \"\\f067\";\n	font-family: FontAwesome;\n	font-size: 16px;\n	font-weight:400;\n}\n\n#wonderplugintabs-TABSID > .wonderplugintabs-header-wrap .wonderplugintabs-header-li:hover {\n	background-color: #fff;\n}\n\n#wonderplugintabs-TABSID > .wonderplugintabs-header-wrap .wonderplugintabs-header-li-active {\n	background-color: #fff;\n}\n\n#wonderplugintabs-TABSID > .wonderplugintabs-header-wrap .wonderplugintabs-header-li-active .wonderplugintabs-header-caption {\n	padding-bottom: 8px;\n	border-bottom: 1px solid #ccc;\n}\n\n#wonderplugintabs-TABSID > .wonderplugintabs-header-wrap .wonderplugintabs-header-li-active .wonderplugintabs-header-caption:after {\n	content: \"\\f068\";\n}\n\n#wonderplugintabs-TABSID > .wonderplugintabs-header-wrap .wonderplugintabs-header-icon-fontawesome {\n	font-family: FontAwesome;\n	line-height: @icon-size;\n	font-size: @icon-size;\n	vertical-align: middle;\n	margin: 8px;\n	color: @icon-color;\n}\n\n#wonderplugintabs-TABSID > .wonderplugintabs-header-wrap .wonderplugintabs-header-icon-image {\n	margin: 4px;\n	vertical-align: middle;\n}\n\n#wonderplugintabs-TABSID > .wonderplugintabs-header-wrap .wonderplugintabs-header-title {\n	display: inline-block;\n	margin: 4px;\n	padding-right: 24px;\n	font-family: \"Open Sans\", Arial, sans-serif;\n	font-size: 14px;\n	font-weight: bold;\n	vertical-align: middle;\n	color: @title-color;\n}\n\n#wonderplugintabs-TABSID > .wonderplugintabs-header-wrap  .wonderplugintabs-panel {\n	box-sizing: border-box;\n	display: block;\n	visibility: hidden;\n	position: relative;\n	top: 0;\n	left: 0;\n	width: 100%;\n	text-align: @panel-text-align;\n	padding: @panel-padding;\n}\n'
	},
	horizontalbluetabs: {
		usetablecellfortitle:			false,
		fixedheadersize:				false,
		fullwidthtabs:					false,
		accordion:						false,
		width: 							800,
		heightmode:						'auto',
		height: 						400,
		minheight:						300,
		triggerresize:					true,
		triggerresizeonload:			true,
		triggerresizeonloadtimeout:		100,
		disablewpautop:					false,
		firstid:						0,
		extendedheight:					false,
		responsive:						true,
		fullwidth:						false,
		direction:						'horizontal',
		tabposition:					'top',
		tabiconposition:				'left',
		horizontaltabalign:				'left',
		fullwidthtabsonsmallscreen:		true,
		accordiononsmallscreen:			true,
		fullwidthtabsonsmallscreenwidth:480,
		hidetitleonsmallscreen:			false,
		hidetitleonsmallscreenwidth: 	768,
		responsivemode:					'arrow',
		tabarrowmode:					'slide',
		horizontalarrowwidthsameasheight:'pixels',
		horizontalarrowwidth:			32,
		arrowprevicon:					'fa-chevron-circle-left',
		arrownexticon:					'fa-chevron-circle-right',
		arrowfontsize:					20,
		arrowfontcolor:					'#666',
		dropdownmenutext:				'More',
		dropdownmenuicon:				'fa-angle-down',
		skinoptions:					'{"title-color" : ["color", "#333", "Title color"], "icon-color" : ["color", "#666", "FontAwesome icon color"], "icon-size" : ["pixel", "18", "Fontawesome icon size"], "title-hover-color" : ["color", "#fff", "Title hover color"], "icon-hover-color" : ["color", "#fff", "FontAwesome icon hover color"], "tab-color" : ["color", "#f6f6f6", "Tab color"],"tab-hover-color" : ["color", "#0073aa", "Tab hover color"], "tab-radius" : ["pixel", "0", "Tab border radius"], "tab-margin" : ["pixel", "4", "Tab margin"], "panel-padding" : ["pixel", "24", "Panel padding"], "panel-text-align" : ["align", "left", "Panel text align"] }',
		skincss:						'@import url(\'https://fonts.googleapis.com/css?family=Open+Sans:400,300,600\');\n\n#wonderplugintabs-TABSID > .wonderplugintabs-header-wrap {\n	box-sizing: border-box;\n	display: block;\n	position: relative;\n	width: 100%;	\n	z-index: 1;\n	margin-top: -1px;\n}\n\n#wonderplugintabs-TABSID > .wonderplugintabs-header-wrap .wonderplugintabs-header-inner-wrap {\n	box-sizing: border-box;\n	display: block;\n	overflow: hidden;	\n}\n\n#wonderplugintabs-TABSID > .wonderplugintabs-header-wrap .wonderplugintabs-header-ul {\n	box-sizing: border-box;\n	display: block;\n	position: relative;\n	list-style: none;\n	white-space: nowrap;\n	margin: 0;\n	padding: 0;\n}\n\n#wonderplugintabs-TABSID > .wonderplugintabs-header-wrap .wonderplugintabs-header-caption {\n	position: relative;\n	cursor: pointer;\n	padding: 8px 12px;\n}\n\n#wonderplugintabs-TABSID > .wonderplugintabs-header-wrap .wonderplugintabs-header-li {\n	box-sizing: border-box;\n	display: inline-block;\n	position: relative;\n	margin: 0 @tab-margin 0 0;\n	padding: 0;\n	vertical-align: bottom;\n	background-color: @tab-color;\n	border-top-left-radius: @tab-radius;\n	border-top-right-radius: @tab-radius;\n}\n\n#wonderplugintabs-TABSID > .wonderplugintabs-header-wrap .wonderplugintabs-header-li-next {\n}\n\n#wonderplugintabs-TABSID > .wonderplugintabs-header-wrap .wonderplugintabs-header-li:hover {\n	background-color: @tab-hover-color;\n}\n\n#wonderplugintabs-TABSID > .wonderplugintabs-header-wrap .wonderplugintabs-header-li-active {\n	background-color: @tab-hover-color;\n}\n\n#wonderplugintabs-TABSID > .wonderplugintabs-header-wrap .wonderplugintabs-header-li-active-last {\n}\n\n#wonderplugintabs-TABSID > .wonderplugintabs-header-wrap .wonderplugintabs-header-li-first {\n}\n\n#wonderplugintabs-TABSID > .wonderplugintabs-header-wrap .wonderplugintabs-header-li-first-side-arrows {\n	margin-left: @tab-margin;\n}\n\n#wonderplugintabs-TABSID > .wonderplugintabs-header-wrap .wonderplugintabs-header-li-last {\n}\n\n#wonderplugintabs-TABSID > .wonderplugintabs-header-wrap .wonderplugintabs-header-li-last-side-arrows {\n}\n\n#wonderplugintabs-TABSID > .wonderplugintabs-header-wrap .wonderplugintabs-header-prev {\n	display: none;\n	text-align: center;\n	position: absolute;\n	top: 0;\n	left: 0;\n	cursor: pointer;\n}\n\n#wonderplugintabs-TABSID > .wonderplugintabs-header-wrap .wonderplugintabs-header-prev:before {\n	position: relative;\n  	top: 50%;\n  	margin-top: -9px;\n  	font-family: FontAwesome;\n  	display: block;\n}\n\n#wonderplugintabs-TABSID > .wonderplugintabs-header-wrap .wonderplugintabs-header-prev:hover {\n}\n\n#wonderplugintabs-TABSID > .wonderplugintabs-header-wrap .wonderplugintabs-header-next {\n	display: none;\n	text-align: center;\n	position: absolute;\n	top: 0;\n	right: 0;\n	cursor: pointer;\n}\n\n#wonderplugintabs-TABSID > .wonderplugintabs-header-wrap .wonderplugintabs-header-next:before {\n	position: relative;\n	top: 50%;\n	margin-top: -9px;\n	font-family: FontAwesome;\n	display: block;\n}\n\n#wonderplugintabs-TABSID > .wonderplugintabs-header-wrap .wonderplugintabs-header-next:hover {\n}\n\n#wonderplugintabs-TABSID > .wonderplugintabs-header-wrap .wonderplugintabs-header-menu {\n	box-sizing: border-box;\n	display: none;\n	text-align: center;\n	position: absolute;\n	top: 0;\n	right: 0;\n	cursor: pointer;\n	background-color: @tab-color;\n	border-top-left-radius: @tab-radius;\n	border-top-right-radius: @tab-radius;\n	padding: 8px 12px;\n	color: @title-color;\n}\n\n#wonderplugintabs-TABSID > .wonderplugintabs-header-wrap .wonderplugintabs-header-menu-caption {\n	display: table-cell;\n	vertical-align: middle;\n}\n\n#wonderplugintabs-TABSID > .wonderplugintabs-header-wrap .wonderplugintabs-header-menu-text {\n	font-family: \"Open Sans\", Arial, sans-serif;\n	font-size: 12px;\n	font-weight: 400;\n	vertical-align: middle;\n}\n\n#wonderplugintabs-TABSID > .wonderplugintabs-header-wrap .wonderplugintabs-header-menu-icon {\n	font-family: FontAwesome;\n	font-size: 14px;\n	vertical-align: middle;\n	margin: 8px;\n}\n\n#wonderplugintabs-TABSID > .wonderplugintabs-header-wrap .wonderplugintabs-header-menu:hover {\n	background-color: @tab-hover-color;	\n	color: @title-hover-color;\n}\n\n#wonderplugintabs-TABSID > .wonderplugintabs-header-wrap .wonderplugintabs-header-menu-dropdown {\n	display: none;\n	position: absolute;\n	white-space: nowrap;\n	top: 100%;\n	right: 0;	\n	box-shadow: 0 6px 12px rgba(0,0,0,.175);\n}\n\n#wonderplugintabs-TABSID > .wonderplugintabs-header-wrap .wonderplugintabs-header-menu-dropdown-item {\n	padding: 12px 32px 12px 20px;	\n	cursor: pointer;\n	text-align: left;\n	background-color: @tab-color;\n}\n\n#wonderplugintabs-TABSID > .wonderplugintabs-header-wrap .wonderplugintabs-header-menu-dropdown-item:hover {\n	background-color: @tab-hover-color;\n}\n\n#wonderplugintabs-TABSID > .wonderplugintabs-header-wrap .wonderplugintabs-header-icon-fontawesome {\n	font-family: FontAwesome;\n	line-height: @icon-size;\n	font-size: @icon-size;\n	vertical-align: middle;\n	margin: 8px;\n	color: @icon-color;\n}\n\n#wonderplugintabs-TABSID > .wonderplugintabs-header-wrap .wonderplugintabs-header-icon-image {\n	margin: 4px;\n	vertical-align: middle;\n}\n\n#wonderplugintabs-TABSID > .wonderplugintabs-header-wrap .wonderplugintabs-header-title {\n	display: inline-block;\n	margin: 4px;\n	font-family: \"Open Sans\", Arial, sans-serif;\n	font-size: 12px;\n	font-weight: 400;\n	vertical-align: middle;\n	color: @title-color;\n}\n\n#wonderplugintabs-TABSID > .wonderplugintabs-header-wrap .wonderplugintabs-header-li:hover .wonderplugintabs-header-title, \n#wonderplugintabs-TABSID > .wonderplugintabs-header-wrap .wonderplugintabs-header-li-active .wonderplugintabs-header-title, \n#wonderplugintabs-TABSID > .wonderplugintabs-header-wrap .wonderplugintabs-header-menu-dropdown-item:hover .wonderplugintabs-header-title {\n	color: @title-hover-color;\n}\n\n#wonderplugintabs-TABSID > .wonderplugintabs-header-wrap .wonderplugintabs-header-li:hover .wonderplugintabs-header-icon-fontawesome, \n#wonderplugintabs-TABSID > .wonderplugintabs-header-wrap .wonderplugintabs-header-li-active .wonderplugintabs-header-icon-fontawesome,\n#wonderplugintabs-TABSID > .wonderplugintabs-header-wrap .wonderplugintabs-header-menu-dropdown-item:hover .wonderplugintabs-header-icon-fontawesome {\n	color: @icon-hover-color;\n}\n\n#wonderplugintabs-TABSID > .wonderplugintabs-header-wrap .wonderplugintabs-header-li-fullwidth {\n	display: block;\n	margin: 0;\n	border-bottom: none;\n	text-align: left;\n}\n\n#wonderplugintabs-TABSID > .wonderplugintabs-header-wrap .wonderplugintabs-header-li-fullwidth:last-child {\n	border-bottom: 1px solid #ccc;\n}\n\n#wonderplugintabs-TABSID > .wonderplugintabs-panel-wrap {\n	box-sizing: border-box;\n	position: relative;\n	display: block;\n	width: 100%;\n	overflow: hidden;\n	border: 2px solid @tab-hover-color;\n	background-color: #fff;	\n}\n\n#wonderplugintabs-TABSID > .wonderplugintabs-panel-wrap > .wonderplugintabs-panel {\n	box-sizing: border-box;\n	display: block;\n	visibility: hidden;\n	position: absolute;\n	top: 0;\n	left: 0;\n	width: 100%;\n	text-align: @panel-text-align;\n	padding: @panel-padding;\n}\n\n#wonderplugintabs-TABSID > .wonderplugintabs-panel-wrap > .wonderplugintabs-panel-active {\n	position: relative;\n}\n\n#wonderplugintabs-TABSID > .wonderplugintabs-header-wrap .wonderplugintabs-header-ul-fullwidth {\n	white-space: normal;\n}\n\n#wonderplugintabs-TABSID > .wonderplugintabs-header-wrap .wonderplugintabs-header-li-fullwidth {\n	padding: 8px;\n	border-radius: 0;\n}\n\n#wonderplugintabs-TABSID > .wonderplugintabs-header-wrap  .wonderplugintabs-panel {\n	padding: @panel-padding;\n	background-color: #fff;	\n	color: #444;\n	margin-top: 8px;\n}\n\n#wonderplugintabs-TABSID > .wonderplugintabs-header-wrap  .wonderplugintabs-panel-active {\n	position: relative;\n}\n\n#wonderplugintabs-TABSID > .wonderplugintabs-header-wrap .wonderplugintabs-header-li-fullwidth .wonderplugintabs-header-caption:after {\n	position:absolute;\n	color:@title-color;\n	top: 12px;\n	right:8px;\n	content: \"\\f107\";\n	font-family: FontAwesome;\n	font-size: 16px;\n	font-weight:400;\n}\n\n#wonderplugintabs-TABSID > .wonderplugintabs-header-wrap .wonderplugintabs-header-li-fullwidth.wonderplugintabs-header-li:hover .wonderplugintabs-header-caption:after {\n	color:@title-hover-color;\n}\n\n#wonderplugintabs-TABSID > .wonderplugintabs-header-wrap .wonderplugintabs-header-li-fullwidth.wonderplugintabs-header-li-active .wonderplugintabs-header-caption:after {\n	content: \"\\f106\";\n	color:@title-hover-color;\n}'	
	},
	horizontaltoptabs: {
		usetablecellfortitle:			false,
		fixedheadersize:				false,
		fullwidthtabs:					false,
		accordion:						false,
		width: 							800,
		heightmode:						'auto',
		height: 						400,
		minheight:						300,
		triggerresize:					true,
		triggerresizeonload:			true,
		triggerresizeonloadtimeout:		100,
		disablewpautop:					false,
		firstid:						0,
		extendedheight:					false,
		responsive:						true,
		fullwidth:						false,
		direction:						'horizontal',
		tabposition:					'top',
		tabiconposition:				'left',
		horizontaltabalign:				'left',
		fullwidthtabsonsmallscreen:		true,
		accordiononsmallscreen:			true,
		fullwidthtabsonsmallscreenwidth:480,
		hidetitleonsmallscreen:			false,
		hidetitleonsmallscreenwidth: 	768,
		responsivemode:					'arrow',
		tabarrowmode:					'slide',
		horizontalarrowwidthsameasheight:'pixels',
		horizontalarrowwidth:			32,
		arrowprevicon:					'fa-chevron-circle-left',
		arrownexticon:					'fa-chevron-circle-right',
		arrowfontsize:					20,
		arrowfontcolor:					'#666',
		dropdownmenutext:				'More',
		dropdownmenuicon:				'fa-angle-down',
		skinoptions:					'{"title-color" : ["color", "#333", "Header title color"], "icon-color" : ["color", "#666", "FontAwesome icon color"], "icon-size" : ["pixel", "18", "Fontawesome icon size"], "tab-radius" : ["pixel", "4", "Tab border radius"], "tab-margin" : ["pixel", "4", "Tab margin"], "panel-padding" : ["pixel", "24", "Panel padding"], "panel-text-align" : ["align", "left", "Panel text align"] }',
		skincss:						'@import url(\'https://fonts.googleapis.com/css?family=Open+Sans:400,300,600\');\n\n#wonderplugintabs-TABSID > .wonderplugintabs-header-wrap {\n	box-sizing: border-box;\n	display: block;\n	position: relative;\n	width: 100%;	\n	z-index: 1;\n	margin-top: -1px;\n}\n\n#wonderplugintabs-TABSID > .wonderplugintabs-header-wrap .wonderplugintabs-header-inner-wrap {\n	box-sizing: border-box;\n	display: block;\n	overflow: hidden;	\n}\n\n#wonderplugintabs-TABSID > .wonderplugintabs-header-wrap .wonderplugintabs-header-ul {\n	box-sizing: border-box;\n	display: block;\n	position: relative;\n	list-style: none;\n	white-space: nowrap;\n	margin: 0;\n	padding: 0;\n}\n\n#wonderplugintabs-TABSID > .wonderplugintabs-header-wrap .wonderplugintabs-header-li {\n	box-sizing: border-box;\n	display: inline-block;\n	position: relative;\n	margin: 0 @tab-margin 0 0;\n	padding: 0px;\n	vertical-align: bottom;\n	background-color: #f6f6f6;\n	border: 1px solid #ccc;\n	border-top-left-radius: @tab-radius;\n	border-top-right-radius: @tab-radius;\n}\n\n#wonderplugintabs-TABSID > .wonderplugintabs-header-wrap .wonderplugintabs-header-caption {\n	cursor: pointer;\n	padding: 8px 12px;\n}\n\n#wonderplugintabs-TABSID > .wonderplugintabs-header-wrap .wonderplugintabs-header-li-next {\n	border-left: 1px solid #ccc;\n}\n\n#wonderplugintabs-TABSID > .wonderplugintabs-header-wrap .wonderplugintabs-header-li:hover {\n	background-color: #fff;\n}\n\n#wonderplugintabs-TABSID > .wonderplugintabs-header-wrap .wonderplugintabs-header-li-active {\n	background-color: #fff;\n	border-bottom: 1px solid #fff;\n}\n\n#wonderplugintabs-TABSID > .wonderplugintabs-header-wrap .wonderplugintabs-header-li-active-last {\n}\n\n#wonderplugintabs-TABSID > .wonderplugintabs-header-wrap .wonderplugintabs-header-li-first {\n}\n\n#wonderplugintabs-TABSID > .wonderplugintabs-header-wrap .wonderplugintabs-header-li-first-side-arrows {\n	margin-left: @tab-margin;\n}\n\n#wonderplugintabs-TABSID > .wonderplugintabs-header-wrap .wonderplugintabs-header-li-last {\n}\n\n#wonderplugintabs-TABSID > .wonderplugintabs-header-wrap .wonderplugintabs-header-li-last-side-arrows {\n}\n\n#wonderplugintabs-TABSID > .wonderplugintabs-header-wrap .wonderplugintabs-header-prev {\n	display: none;\n	text-align: center;\n	position: absolute;\n	top: 0;\n	left: 0;\n	cursor: pointer;\n}\n\n#wonderplugintabs-TABSID > .wonderplugintabs-header-wrap .wonderplugintabs-header-prev:before {\n	position: relative;\n	top: 50%;\n	margin-top: -9px;\n	font-family: FontAwesome;\n	display: block;\n}\n\n#wonderplugintabs-TABSID > .wonderplugintabs-header-wrap .wonderplugintabs-header-prev:hover {\n}\n\n#wonderplugintabs-TABSID > .wonderplugintabs-header-wrap .wonderplugintabs-header-next {\n	display: none;\n	text-align: center;\n	position: absolute;\n	top: 0;\n	right: 0;\n	cursor: pointer;\n}\n\n#wonderplugintabs-TABSID > .wonderplugintabs-header-wrap .wonderplugintabs-header-next:before {\n	position: relative;\n	top: 50%;\n	margin-top: -9px;\n	font-family: FontAwesome;\n	display: block;\n}\n\n#wonderplugintabs-TABSID > .wonderplugintabs-header-wrap .wonderplugintabs-header-next:hover {\n}\n\n#wonderplugintabs-TABSID > .wonderplugintabs-header-wrap .wonderplugintabs-header-menu {\n	box-sizing: border-box;\n	display: none;\n	text-align: center;\n	position: absolute;\n	top: 0;\n	right: 0;\n	cursor: pointer;\n	background-color: #f6f6f6;\n	border: 1px solid #ccc;\n	border-top-left-radius: @tab-radius;\n	border-top-right-radius: @tab-radius;\n	padding: 8px 12px;\n}\n\n#wonderplugintabs-TABSID > .wonderplugintabs-header-wrap .wonderplugintabs-header-menu-caption {\n	display: table-cell;\n	vertical-align: middle;\n}\n\n#wonderplugintabs-TABSID > .wonderplugintabs-header-wrap .wonderplugintabs-header-menu-text {\n	font-family: \"Open Sans\", Arial, sans-serif;\n	font-size: 12px;\n	font-weight: 400;\n	vertical-align: middle;\n	color: #333;\n}\n\n#wonderplugintabs-TABSID > .wonderplugintabs-header-wrap .wonderplugintabs-header-menu-icon {\n	font-family: FontAwesome;\n	font-size: 14px;\n	vertical-align: middle;\n	margin: 8px;\n	color: #666;\n}\n\n#wonderplugintabs-TABSID > .wonderplugintabs-header-wrap .wonderplugintabs-header-menu:hover {\n	background-color: #fff;	\n}\n\n#wonderplugintabs-TABSID > .wonderplugintabs-header-wrap .wonderplugintabs-header-menu-dropdown {\n	display: none;\n	position: absolute;\n	white-space: nowrap;\n	top: 100%;\n	right: 0;	\n	border-left: 1px solid #ccc;\n	border-right: 1px solid #ccc;\n	border-bottom: 1px solid #ccc;\n	box-shadow: 0 6px 12px rgba(0,0,0,.175);\n}\n\n#wonderplugintabs-TABSID > .wonderplugintabs-header-wrap .wonderplugintabs-header-menu-dropdown-item {\n	padding: 12px 32px 12px 20px;	\n	cursor: pointer;\n	text-align: left;\n	background-color: #fff;\n}\n\n#wonderplugintabs-TABSID > .wonderplugintabs-header-wrap .wonderplugintabs-header-menu-dropdown-item:hover {\n	background-color: #f9f9f9;	\n}\n\n#wonderplugintabs-TABSID > .wonderplugintabs-header-wrap .wonderplugintabs-header-icon-fontawesome {\n	font-family: FontAwesome;\n	font-size: @icon-size;\n	line-height: @icon-size;\n	vertical-align: middle;\n	margin: 8px;\n	color: @icon-color;\n}\n\n#wonderplugintabs-TABSID > .wonderplugintabs-header-wrap .wonderplugintabs-header-icon-image {\n	margin: 4px;\n	vertical-align: middle;\n}\n\n#wonderplugintabs-TABSID > .wonderplugintabs-header-wrap .wonderplugintabs-header-title {\n	display: inline-block;\n	margin: 4px;\n	font-family: \"Open Sans\", Arial, sans-serif;\n	font-size: 12px;\n	font-weight: 400;\n	vertical-align: middle;\n	color: @title-color;\n}\n\n#wonderplugintabs-TABSID > .wonderplugintabs-header-wrap .wonderplugintabs-header-li-fullwidth {\n	display: block;\n	margin: 0;\n	border-bottom: none;\n	text-align: left;\n}\n\n#wonderplugintabs-TABSID > .wonderplugintabs-header-wrap .wonderplugintabs-header-li-fullwidth:last-child {\n	border-bottom: 1px solid #ccc;\n}\n\n#wonderplugintabs-TABSID > .wonderplugintabs-panel-wrap {\n	box-sizing: border-box;\n	position: relative;\n	display: block;\n	width: 100%;\n	overflow: hidden;\n	border: 1px solid #ccc;\n	background-color: #fff;	\n	margin-top: -1px;\n}\n\n#wonderplugintabs-TABSID > .wonderplugintabs-panel-wrap > .wonderplugintabs-panel {\n	box-sizing: border-box;\n	display: block;\n	visibility: hidden;\n	position: absolute;\n	top: 0;\n	left: 0;\n	width: 100%;\n	text-align: @panel-text-align;\n	padding: @panel-padding;\n}\n\n#wonderplugintabs-TABSID > .wonderplugintabs-panel-wrap > .wonderplugintabs-panel-active {\n	position: relative;\n}\n\n#wonderplugintabs-TABSID > .wonderplugintabs-header-wrap .wonderplugintabs-header-ul-fullwidth {\n	white-space: normal;\n}\n\n#wonderplugintabs-TABSID > .wonderplugintabs-header-wrap .wonderplugintabs-header-li-fullwidth {\n	border-radius: 0;\n}\n\n#wonderplugintabs-TABSID > .wonderplugintabs-header-wrap  .wonderplugintabs-panel {\n	padding: @panel-padding;\n	text-align: @panel-text-align;\n}\n\n#wonderplugintabs-TABSID > .wonderplugintabs-header-wrap  .wonderplugintabs-panel-active {\n	position: relative;\n}\n\n#wonderplugintabs-TABSID > .wonderplugintabs-header-wrap .wonderplugintabs-header-li-fullwidth .wonderplugintabs-header-caption:after {\n	position:absolute;\n	color:@title-color;\n	top: 12px;\n	right:8px;\n	content: \"\\f107\";\n	font-family: FontAwesome;\n	font-size: 16px;\n	font-weight:400;\n}\n\n#wonderplugintabs-TABSID > .wonderplugintabs-header-wrap .wonderplugintabs-header-li-fullwidth.wonderplugintabs-header-li-active .wonderplugintabs-header-caption:after {\n	content: \"\\f106\";\n}'
	},
	horizontalbottomtabs: {
		usetablecellfortitle:			false,
		fixedheadersize:				false,
		fullwidthtabs:					false,
		accordion:						false,
		width: 							800,
		heightmode:						'auto',
		height: 						400,
		minheight:						300,
		triggerresize:					true,
		triggerresizeonload:			true,
		triggerresizeonloadtimeout:		100,
		disablewpautop:					false,
		firstid:						0,
		extendedheight:					false,
		responsive:						true,
		fullwidth:						false,
		direction:						'horizontal',
		tabposition:					'bottom',
		tabiconposition:				'left',
		horizontaltabalign:				'left',
		fullwidthtabsonsmallscreen:		true,
		accordiononsmallscreen:			true,
		fullwidthtabsonsmallscreenwidth:480,
		hidetitleonsmallscreen:			false,
		hidetitleonsmallscreenwidth: 	768,
		responsivemode:					'arrow',
		tabarrowmode:					'slide',
		horizontalarrowwidthsameasheight:'pixels',
		horizontalarrowwidth:			32,
		arrowprevicon:					'fa-chevron-circle-left',
		arrownexticon:					'fa-chevron-circle-right',
		arrowfontsize:					20,
		arrowfontcolor:					'#666',
		dropdownmenutext:				'More',
		dropdownmenuicon:				'fa-angle-up',
		skinoptions:					'{"title-color" : ["color", "#333", "Title color"], "icon-color" : ["color", "#666", "FontAwesome icon color"], "icon-size" : ["pixel", "18", "Fontawesome icon size"], "tab-radius" : ["pixel", "4", "Tab border radius"], "tab-margin" : ["pixel", "4", "Tab margin"], "panel-padding" : ["pixel", "24", "Panel padding"], "panel-text-align" : ["align", "left", "Panel text align"] }',
		skincss:						'@import url(\'https://fonts.googleapis.com/css?family=Open+Sans:400,300,600\');\n\n#wonderplugintabs-TABSID > .wonderplugintabs-header-wrap {\n	box-sizing: border-box;\n	display: block;\n	position: relative;\n	width: 100%;	\n	z-index: 1;\n	margin-top: -1px;\n}\n\n#wonderplugintabs-TABSID > .wonderplugintabs-header-wrap .wonderplugintabs-header-inner-wrap {\n	box-sizing: border-box;\n	display: block;\n	overflow: hidden;	\n}\n\n#wonderplugintabs-TABSID > .wonderplugintabs-header-wrap .wonderplugintabs-header-ul {\n	box-sizing: border-box;\n	display: block;\n	position: relative;\n	list-style: none;\n	white-space: nowrap;\n	margin: 0;\n	padding: 0;\n}\n\n#wonderplugintabs-TABSID > .wonderplugintabs-header-wrap .wonderplugintabs-header-li {\n	box-sizing: border-box;\n	display: inline-block;\n	position: relative;\n	margin: 0 @tab-margin 0 0;\n	padding: 0px;\n	vertical-align: top;\n	background-color: #f6f6f6;\n	border: 1px solid #ccc;\n	border-bottom-left-radius: @tab-radius;\n	border-bottom-right-radius: @tab-radius;\n}\n\n#wonderplugintabs-TABSID > .wonderplugintabs-header-wrap .wonderplugintabs-header-caption {\n	cursor: pointer;\n	padding: 8px 12px;\n}\n\n#wonderplugintabs-TABSID > .wonderplugintabs-header-wrap .wonderplugintabs-header-li-next {\n	border-left: 1px solid #ccc;\n}\n\n#wonderplugintabs-TABSID > .wonderplugintabs-header-wrap .wonderplugintabs-header-li:hover {\n	background-color: #fff;\n}\n\n#wonderplugintabs-TABSID > .wonderplugintabs-header-wrap .wonderplugintabs-header-li-active {\n	background-color: #fff;\n	border-top: 1px solid #fff;\n}\n\n#wonderplugintabs-TABSID > .wonderplugintabs-header-wrap .wonderplugintabs-header-li-active-last {\n}\n\n#wonderplugintabs-TABSID > .wonderplugintabs-header-wrap .wonderplugintabs-header-li-first {\n}\n\n#wonderplugintabs-TABSID > .wonderplugintabs-header-wrap .wonderplugintabs-header-li-first-side-arrows {\n	margin-left: @tab-margin;\n}\n\n#wonderplugintabs-TABSID > .wonderplugintabs-header-wrap .wonderplugintabs-header-li-last {\n}\n\n#wonderplugintabs-TABSID > .wonderplugintabs-header-wrap .wonderplugintabs-header-li-last-side-arrows {\n}\n\n#wonderplugintabs-TABSID > .wonderplugintabs-header-wrap .wonderplugintabs-header-prev {\n	display: none;\n	text-align: center;\n	position: absolute;\n	top: 0;\n	left: 0;\n	cursor: pointer;\n}\n\n#wonderplugintabs-TABSID > .wonderplugintabs-header-wrap .wonderplugintabs-header-prev:before {\n	position: relative;\n	top: 50%;\n	margin-top: -9px;\n	font-family: FontAwesome;\n	display: block;\n}\n\n#wonderplugintabs-TABSID > .wonderplugintabs-header-wrap .wonderplugintabs-header-prev:hover {\n}\n\n#wonderplugintabs-TABSID > .wonderplugintabs-header-wrap .wonderplugintabs-header-next {\n	display: none;\n	text-align: center;\n	position: absolute;\n	top: 0;\n	right: 0;\n	cursor: pointer;\n}\n\n#wonderplugintabs-TABSID > .wonderplugintabs-header-wrap .wonderplugintabs-header-next:before {\n	position: relative;\n	top: 50%;\n	margin-top: -9px;\n	font-family: FontAwesome;\n	display: block;\n}\n\n#wonderplugintabs-TABSID > .wonderplugintabs-header-wrap .wonderplugintabs-header-next:hover {\n}\n\n#wonderplugintabs-TABSID > .wonderplugintabs-header-wrap .wonderplugintabs-header-menu {\n	box-sizing: border-box;\n	display: none;\n	text-align: center;\n	position: absolute;\n	top: 0;\n	right: 0;\n	cursor: pointer;\n	background-color: #f6f6f6;\n	border: 1px solid #ccc;\n	border-bottom-left-radius: @tab-radius;\n	border-bottom-right-radius: @tab-radius;\n	padding: 8px 12px;\n}\n\n#wonderplugintabs-TABSID > .wonderplugintabs-header-wrap .wonderplugintabs-header-menu-caption {\n	display: table-cell;\n	vertical-align: middle;\n}\n\n#wonderplugintabs-TABSID > .wonderplugintabs-header-wrap .wonderplugintabs-header-menu-text {\n	font-family: \"Open Sans\", Arial, sans-serif;\n	font-size: 12px;\n	font-weight: 400;\n	vertical-align: middle;\n	color: #333;\n}\n\n#wonderplugintabs-TABSID > .wonderplugintabs-header-wrap .wonderplugintabs-header-menu-icon {\n	font-family: FontAwesome;\n	font-size: 14px;\n	vertical-align: middle;\n	margin: 8px;\n	color: #666;\n}\n\n#wonderplugintabs-TABSID > .wonderplugintabs-header-wrap .wonderplugintabs-header-menu:hover {\n	background-color: #fff;	\n}\n\n#wonderplugintabs-TABSID > .wonderplugintabs-header-wrap .wonderplugintabs-header-menu-dropdown {\n	box-sizing: border-box;\n	display: none;\n	position: absolute;\n	white-space: nowrap;\n	bottom: 100%;\n	right: 0;	\n	border-left: 1px solid #ccc;\n	border-right: 1px solid #ccc;\n	border-top: 1px solid #ccc;\n}\n\n#wonderplugintabs-TABSID > .wonderplugintabs-header-wrap .wonderplugintabs-header-menu-dropdown-item {\n	padding: 12px 32px 12px 20px;	\n	cursor: pointer;\n	text-align: left;\n	background-color: #fff;\n}\n\n#wonderplugintabs-TABSID > .wonderplugintabs-header-wrap .wonderplugintabs-header-menu-dropdown-item:hover {\n	background-color: #f9f9f9;	\n}\n\n#wonderplugintabs-TABSID > .wonderplugintabs-header-wrap .wonderplugintabs-header-icon-fontawesome {\n	font-family: FontAwesome;\n	line-height: @icon-size;\n	font-size: @icon-size;\n	vertical-align: middle;\n	margin: 8px;\n	color: @icon-color;\n}\n\n#wonderplugintabs-TABSID > .wonderplugintabs-header-wrap .wonderplugintabs-header-icon-image {\n	margin: 4px;\n	vertical-align: middle;\n}\n\n#wonderplugintabs-TABSID > .wonderplugintabs-header-wrap .wonderplugintabs-header-title {\n	display: inline-block;\n	margin: 4px;\n	font-family: \"Open Sans\", Arial, sans-serif;\n	font-size: 12px;\n	font-weight: 400;\n	vertical-align: middle;\n	color: @title-color;\n}\n\n#wonderplugintabs-TABSID > .wonderplugintabs-header-wrap .wonderplugintabs-header-li-fullwidth {\n	display: block;\n	margin: 0;\n	border-top: none;\n	text-align: left;\n}\n\n#wonderplugintabs-TABSID > .wonderplugintabs-header-wrap .wonderplugintabs-header-li-fullwidth:first-child {\n	border-top: 1px solid #ccc;\n}\n\n#wonderplugintabs-TABSID > .wonderplugintabs-panel-wrap {\n	box-sizing: border-box;\n	position: relative;\n	display: block;\n	width: 100%;\n	overflow: hidden;\n	border: 1px solid #ccc;\n	background-color: #fff;	\n}\n\n#wonderplugintabs-TABSID > .wonderplugintabs-panel-wrap > .wonderplugintabs-panel {\n	box-sizing: border-box;\n	display: block;\n	visibility: hidden;\n	position: absolute;\n	top: 0;\n	left: 0;\n	width: 100%;\n	text-align: @panel-text-align;\n	padding: @panel-padding;\n}\n\n#wonderplugintabs-TABSID > .wonderplugintabs-panel-wrap > .wonderplugintabs-panel-active {\n	position: relative;\n}\n\n#wonderplugintabs-TABSID > .wonderplugintabs-header-wrap .wonderplugintabs-header-ul-fullwidth {\n	white-space: normal;\n}\n\n#wonderplugintabs-TABSID > .wonderplugintabs-header-wrap .wonderplugintabs-header-li-fullwidth {\n	border-radius: 0;\n}\n\n#wonderplugintabs-TABSID > .wonderplugintabs-header-wrap  .wonderplugintabs-panel {\n	padding: @panel-padding;\n	text-align: @panel-text-align;\n}\n\n#wonderplugintabs-TABSID > .wonderplugintabs-header-wrap  .wonderplugintabs-panel-active {\n	position: relative;\n}\n\n#wonderplugintabs-TABSID > .wonderplugintabs-header-wrap .wonderplugintabs-header-li-fullwidth .wonderplugintabs-header-caption:after {\n	position:absolute;\n	color:@title-color;\n	top: 12px;\n	right:8px;\n	content: \"\\f107\";\n	font-family: FontAwesome;\n	font-size: 16px;\n	font-weight:400;\n}\n\n#wonderplugintabs-TABSID > .wonderplugintabs-header-wrap .wonderplugintabs-header-li-fullwidth.wonderplugintabs-header-li-active .wonderplugintabs-header-caption:after {\n	content: \"\\f106\";\n}'
	},
	
	verticalleftdarktabs: {
		usetablecellfortitle:			false,
		fixedheadersize:				false,
		fullwidthtabs:					false,
		accordion:						false,
		width: 							800,
		heightmode:						'auto',
		height: 						400,
		minheight:						300,
		triggerresize:					true,
		triggerresizeonload:			true,
		triggerresizeonloadtimeout:		100,
		disablewpautop:					false,
		firstid:						0,
		extendedheight:					false,
		responsive:						true,
		fullwidth:						false,
		direction:						'vertical',
		tabposition:					'left',
		tabiconposition:				'left',
		horizontaltabalign:				'left',
		fullwidthtabsonsmallscreen:		true,
		accordiononsmallscreen:			true,
		fullwidthtabsonsmallscreenwidth:480,
		hidetitleonsmallscreen:			false,
		hidetitleonsmallscreenwidth: 	768,
		responsivemode:					'menu',
		tabarrowmode:					'slide',
		horizontalarrowwidthsameasheight:'pixels',
		horizontalarrowwidth:			32,
		arrowprevicon:					'fa-angle-up',
		arrownexticon:					'fa-angle-down',
		arrowfontsize:					20,
		arrowfontcolor:					'#666',
		dropdownmenutext:				'More',
		dropdownmenuicon:				'fa-angle-right',
		skinoptions:					'{"title-color" : ["color", "#fff", "Title color"], "icon-color" : ["color", "#fed009", "FontAwesome icon color"], "icon-size" : ["pixel", "16", "Fontawesome icon size"], "tab-color" : ["color", "#393536", "Tab color"], "tab-top-border" : ["color", "#434041", "Tab top border"], "tab-bottom-border" : ["color", "#0d0d0d", "Tab bottom border"], "tab-hover-color" : ["color", "#222", "Tab hover color"], "tab-margin" : ["pixel", "0", "Tab margin"], "panel-padding" : ["pixel", "24", "Panel padding"], "panel-text-align" : ["align", "left", "Panel text align"] }',
		skincss:						'@import url(\'https://fonts.googleapis.com/css?family=Open+Sans:400,300,600\');\n\n#wonderplugintabs-TABSID > .wonderplugintabs-header-wrap {\n	box-sizing: border-box;\n	display: block;\n	position: relative;\n	z-index: 1;\n	float: left;\n}\n\n#wonderplugintabs-TABSID > .wonderplugintabs-header-wrap .wonderplugintabs-header-inner-wrap {\n	box-sizing: border-box;\n	display: block;\n	height: 100%;\n	overflow: hidden;\n}\n\n#wonderplugintabs-TABSID > .wonderplugintabs-header-wrap .wonderplugintabs-header-ul {\n	box-sizing: border-box;\n	display: block;\n	position: relative;\n	list-style: none;\n	margin: 0;\n	padding: 0;\n	color: #fff;\n}\n\n#wonderplugintabs-TABSID > .wonderplugintabs-header-wrap .wonderplugintabs-header-caption {\n	cursor: pointer;\n	padding: 10px;\n}\n\n#wonderplugintabs-TABSID > .wonderplugintabs-header-wrap .wonderplugintabs-header-li {\n	box-sizing: border-box;\n	display: block;\n	position: relative;\n	text-align: left;\n	margin: 0 0 @tab-margin 0;\n	padding: 0px;\n	background-color: @tab-color;\n	border-top: 1px solid @tab-top-border;\n	border-bottom: 1px solid @tab-bottom-border;\n}\n\n#wonderplugintabs-TABSID > .wonderplugintabs-header-wrap .wonderplugintabs-header-li:hover {\n	background-color: @tab-hover-color;\n}\n\n#wonderplugintabs-TABSID > .wonderplugintabs-header-wrap .wonderplugintabs-header-li-active {\n	background-color: @tab-hover-color;\n}\n\n#wonderplugintabs-TABSID > .wonderplugintabs-header-wrap .wonderplugintabs-header-li-active:after {\n	position: absolute;\n	top: 50%;\n	margin-top: -8px;\n	left: 100%;\n	content: \" \";\n	height: 0;\n	width: 0;\n	border-top: 8px solid transparent;\n	border-bottom: 8px solid transparent;\n	border-left: 8px solid @tab-hover-color;\n	z-index: 100;\n}\n\n#wonderplugintabs-TABSID > .wonderplugintabs-header-wrap-fullwidth .wonderplugintabs-header-li-active:after {\n	display:none;\n}\n\n#wonderplugintabs-TABSID > .wonderplugintabs-header-wrap .wonderplugintabs-header-prev {\n	display: none;\n	text-align: center;\n	position: absolute;\n	top: 0;\n	left: 0;\n	width: 100%;\n	cursor: pointer;\n	background-color: transparent;\n	height:	40px;\n	z-index: 1;\n}\n\n#wonderplugintabs-TABSID > .wonderplugintabs-header-wrap .wonderplugintabs-header-prev:before {\n	position: relative;\n	top: 50%;\n	margin-top: -9px;\n	font-family: FontAwesome;\n	font-weight: bold;\n	display: block;\n}\n\n#wonderplugintabs-TABSID > .wonderplugintabs-header-wrap .wonderplugintabs-header-prev:hover:before {\n	color: #333;\n}\n\n#wonderplugintabs-TABSID > .wonderplugintabs-header-wrap .wonderplugintabs-header-next {\n	display: none;\n	text-align: center;\n	position: absolute;\n	bottom: 0;\n	left: 0;\n	width: 100%;\n	cursor:pointer;\n	background-color: transparent;\n	height: 40px;\n	z-index: 1;\n}\n\n#wonderplugintabs-TABSID > .wonderplugintabs-header-wrap .wonderplugintabs-header-next:before {\n	position: relative;\n	top: 50%;\n	margin-top: -9px;\n	font-family: FontAwesome;\n	font-weight: bold;\n	display: block;\n}\n\n#wonderplugintabs-TABSID > .wonderplugintabs-header-wrap .wonderplugintabs-header-next:hover:before {\n	color: #333;\n}\n\n#wonderplugintabs-TABSID > .wonderplugintabs-header-wrap .wonderplugintabs-header-menu {\n	box-sizing: border-box;\n	display: none;\n	text-align: center;\n	position: absolute;\n	bottom: 0;\n	left: 0;\n	cursor: pointer;\n	width: 100%;\n	background-color: @tab-color;\n	padding: 10px;\n}\n\n#wonderplugintabs-TABSID > .wonderplugintabs-header-wrap .wonderplugintabs-header-menu-caption {\n	display: table-cell;\n	vertical-align: middle;\n}\n\n#wonderplugintabs-TABSID > .wonderplugintabs-header-wrap .wonderplugintabs-header-menu-text {\n	font-family: \"Open Sans\", Arial, sans-serif;\n	font-size: 12px;\n	font-weight: 400;\n	vertical-align: middle;\n	color: @title-color;\n}\n\n#wonderplugintabs-TABSID > .wonderplugintabs-header-wrap .wonderplugintabs-header-menu-icon {\n	font-family: FontAwesome;\n	font-size: 14px;\n	vertical-align: middle;\n	margin: 8px;\n	color: @icon-color;\n}\n\n#wonderplugintabs-TABSID > .wonderplugintabs-header-wrap .wonderplugintabs-header-menu:hover {\n	background-color: @tab-hover-color;	\n}\n\n#wonderplugintabs-TABSID > .wonderplugintabs-header-wrap .wonderplugintabs-header-menu-dropdown {\n	box-sizing: border-box;\n	display: none;\n	position: absolute;\n	white-space: nowrap;\n	bottom: 0;\n	left: 100%;	\n}\n\n#wonderplugintabs-TABSID > .wonderplugintabs-header-wrap .wonderplugintabs-header-menu-dropdown-item {\n	padding: 12px 32px 12px 20px;	\n	cursor: pointer;\n	text-align: left;\n	background-color: @tab-color;\n}\n\n#wonderplugintabs-TABSID > .wonderplugintabs-header-wrap .wonderplugintabs-header-menu-dropdown-item:hover {\n	background-color: @tab-hover-color;	\n}\n\n#wonderplugintabs-TABSID > .wonderplugintabs-header-wrap .wonderplugintabs-header-icon-fontawesome {\n	font-family: FontAwesome;\n	line-height: @icon-size;\n	font-size: @icon-size;\n	vertical-align: middle;\n	margin: 8px;\n	color: @icon-color;\n}\n\n#wonderplugintabs-TABSID > .wonderplugintabs-header-wrap .wonderplugintabs-header-icon-image {\n	margin: 4px;\n	vertical-align: middle;\n}\n\n#wonderplugintabs-TABSID > .wonderplugintabs-header-wrap .wonderplugintabs-header-title {\n	display: inline-block;\n	margin: 4px;\n	font-family: \"Open Sans\", Arial, sans-serif;\n	font-size: 12px;\n	font-weight: 400;\n	vertical-align: middle;\n	color: @title-color;\n	white-space: nowrap;\n}\n\n#wonderplugintabs-TABSID > .wonderplugintabs-header-wrap-fullwidth {\n	float: none;\n}\n\n#wonderplugintabs-TABSID > .wonderplugintabs-panel-wrap-fullwidth {\n	left: 0;\n}\n\n#wonderplugintabs-TABSID > .wonderplugintabs-header-wrap .wonderplugintabs-header-li-fullwidth {\n	display: block;\n	text-align: left;\n}\n\n#wonderplugintabs-TABSID > .wonderplugintabs-panel-wrap {\n	box-sizing: border-box;\n	position: relative;\n	display: block;\n	overflow: hidden;\n	background-color: #fff;	\n}\n\n#wonderplugintabs-TABSID > .wonderplugintabs-panel-wrap > .wonderplugintabs-panel {\n	box-sizing: border-box;\n	display: block;\n	visibility: hidden;\n	position: absolute;\n	top: 0;\n	left: 0;\n	width: 100%;\n	text-align: @panel-text-align;\n	padding: @panel-padding;\n}\n\n#wonderplugintabs-TABSID > .wonderplugintabs-panel-wrap > .wonderplugintabs-panel-active {\n	position: relative;\n}\n\n#wonderplugintabs-TABSID > .wonderplugintabs-header-wrap .wonderplugintabs-header-ul-fullwidth {\n	white-space: normal;\n}\n\n#wonderplugintabs-TABSID > .wonderplugintabs-header-wrap .wonderplugintabs-header-li-fullwidth {\n	padding: 8px;\n	border-radius: 0;\n}\n\n#wonderplugintabs-TABSID > .wonderplugintabs-header-wrap  .wonderplugintabs-panel {\n	padding: @panel-padding;\n	background-color: #fff;	\n	color: #444;\n	margin-top: 8px;\n}\n\n#wonderplugintabs-TABSID > .wonderplugintabs-header-wrap  .wonderplugintabs-panel-active {\n	position: relative;\n}\n\n#wonderplugintabs-TABSID > .wonderplugintabs-header-wrap .wonderplugintabs-header-li-fullwidth .wonderplugintabs-header-caption:after {\n	position:absolute;\n	color:@title-color;\n	top: 12px;\n	right:8px;\n	content: \"\\f107\";\n	font-family: FontAwesome;\n	font-size: 16px;\n	font-weight:400;\n}\n\n#wonderplugintabs-TABSID > .wonderplugintabs-header-wrap .wonderplugintabs-header-li-fullwidth.wonderplugintabs-header-li-active .wonderplugintabs-header-caption:after {\n	content: \"\\f106\";\n}'
	},
	
	verticallefttabs: {
		usetablecellfortitle:			false,
		fixedheadersize:				false,
		fullwidthtabs:					false,
		accordion:						false,
		width: 							800,
		heightmode:						'auto',
		height: 						400,
		minheight:						300,
		triggerresize:					true,
		triggerresizeonload:			true,
		triggerresizeonloadtimeout:		100,
		disablewpautop:					false,
		firstid:						0,
		extendedheight:					false,
		responsive:						true,
		fullwidth:						false,
		direction:						'vertical',
		tabposition:					'left',
		tabiconposition:				'left',
		horizontaltabalign:				'left',
		fullwidthtabsonsmallscreen:		true,
		accordiononsmallscreen:			true,
		fullwidthtabsonsmallscreenwidth:480,
		hidetitleonsmallscreen:			false,
		hidetitleonsmallscreenwidth: 	768,
		responsivemode:					'menu',
		tabarrowmode:					'slide',
		horizontalarrowwidthsameasheight:'pixels',
		horizontalarrowwidth:			32,
		arrowprevicon:					'fa-angle-up',
		arrownexticon:					'fa-angle-down',
		arrowfontsize:					20,
		arrowfontcolor:					'#666',
		dropdownmenutext:				'More',
		dropdownmenuicon:				'fa-angle-right',
		skinoptions:					'{"title-color" : ["color", "#333", "Title color"], "icon-color" : ["color", "#666", "FontAwesome icon color"], "icon-size" : ["pixel", "16", "Fontawesome icon size"], "tab-radius" : ["pixel", "4", "Tab border radius"], "tab-margin" : ["pixel", "4", "Tab margin"], "panel-padding" : ["pixel", "24", "Panel padding"], "panel-text-align" : ["align", "left", "Panel text align"] }',
		skincss:						'@import url(\'https://fonts.googleapis.com/css?family=Open+Sans:400,300,600\');\n\n#wonderplugintabs-TABSID > .wonderplugintabs-header-wrap {\n	box-sizing: border-box;\n	display: block;\n	position: relative;\n	z-index: 1;\n	float: left;\n}\n\n#wonderplugintabs-TABSID > .wonderplugintabs-header-wrap .wonderplugintabs-header-inner-wrap {\n	box-sizing: border-box;\n	display: block;\n	height: 100%;\n	overflow: hidden;	\n}\n\n#wonderplugintabs-TABSID > .wonderplugintabs-header-wrap .wonderplugintabs-header-inner-wrap-arrows {\n	padding-top: @tab-margin;\n}\n\n#wonderplugintabs-TABSID > .wonderplugintabs-header-wrap .wonderplugintabs-header-ul {\n	box-sizing: border-box;\n	display: block;\n	position: relative;\n	list-style: none;\n	margin: 0;\n	padding: 0;\n}\n\n#wonderplugintabs-TABSID > .wonderplugintabs-header-wrap .wonderplugintabs-header-caption {\n	cursor: pointer;\n	padding: 8px 12px;\n}\n\n#wonderplugintabs-TABSID > .wonderplugintabs-header-wrap .wonderplugintabs-header-li {\n	box-sizing: border-box;\n	display: block;\n	position: relative;\n	text-align: left;\n	margin: 0 0 @tab-margin 0;\n	padding: 0px;\n	background-color: #f6f6f6;\n	border: 1px solid #ccc;\n	border-top-left-radius: @tab-radius;\n	border-bottom-left-radius: @tab-radius;\n}\n\n#wonderplugintabs-TABSID > .wonderplugintabs-header-wrap .wonderplugintabs-header-li-next {\n	border-left: 1px solid #ccc;\n}\n\n#wonderplugintabs-TABSID > .wonderplugintabs-header-wrap .wonderplugintabs-header-li:hover {\n	background-color: #fff;\n}\n\n#wonderplugintabs-TABSID > .wonderplugintabs-header-wrap .wonderplugintabs-header-li-active {\n	background-color: #fff;\n	border-right: none;\n}\n\n#wonderplugintabs-TABSID > .wonderplugintabs-header-wrap .wonderplugintabs-header-li-active-last {\n}\n\n#wonderplugintabs-TABSID > .wonderplugintabs-header-wrap .wonderplugintabs-header-li-first {\n}\n\n#wonderplugintabs-TABSID > .wonderplugintabs-header-wrap .wonderplugintabs-header-li-first-side-arrows {\n}\n\n#wonderplugintabs-TABSID > .wonderplugintabs-header-wrap .wonderplugintabs-header-li-last {\n}\n\n#wonderplugintabs-TABSID > .wonderplugintabs-header-wrap .wonderplugintabs-header-li-last-side-arrows {\n}\n\n#wonderplugintabs-TABSID > .wonderplugintabs-header-wrap .wonderplugintabs-header-prev {\n	display: none;\n	text-align: center;\n	position: absolute;\n	top: 0;\n	left: 0;\n	width: 100%;\n	cursor: pointer;\n	background-color: #f6f6f6;\n	border: 1px solid #ccc;\n	border-top-left-radius: @tab-radius;\n	border-bottom-left-radius: @tab-radius;\n	height:	40px;\n	z-index: 1;\n}\n\n#wonderplugintabs-TABSID > .wonderplugintabs-header-wrap .wonderplugintabs-header-prev:before {\n	position: relative;\n	top: 50%;\n	margin-top: -9px;\n	font-family: FontAwesome;\n	display: block;\n}\n\n#wonderplugintabs-TABSID > .wonderplugintabs-header-wrap .wonderplugintabs-header-prev:hover {\n	background-color: #fff;	\n}\n\n#wonderplugintabs-TABSID > .wonderplugintabs-header-wrap .wonderplugintabs-header-next {\n	display: none;\n	text-align: center;\n	position: absolute;\n	bottom: 0;\n	left: 0;\n	width: 100%;\n	cursor:pointer;\n	background-color: #f6f6f6;\n	border: 1px solid #ccc;\n	border-top-left-radius: @tab-radius;\n	border-bottom-left-radius: @tab-radius;\n	height:	40px;\n	z-index: 1;\n}\n\n#wonderplugintabs-TABSID > .wonderplugintabs-header-wrap .wonderplugintabs-header-next:before {\n	position: relative;\n	top: 50%;\n	margin-top: -9px;\n	font-family: FontAwesome;\n	display: block;\n}\n\n#wonderplugintabs-TABSID > .wonderplugintabs-header-wrap .wonderplugintabs-header-next:hover {\n	background-color: #fff;	\n}\n\n#wonderplugintabs-TABSID > .wonderplugintabs-header-wrap .wonderplugintabs-header-menu {\n	box-sizing: border-box;\n	display: none;\n	text-align: center;\n	position: absolute;\n	bottom: 0;\n	left: 0;\n	cursor: pointer;\n	width: 100%;\n	background-color: #f6f6f6;\n	border: 1px solid #ccc;\n	border-top-left-radius: @tab-radius;\n	border-bottom-left-radius: @tab-radius;\n	padding: 8px 12px;\n}\n\n#wonderplugintabs-TABSID > .wonderplugintabs-header-wrap .wonderplugintabs-header-menu-caption {\n	display: table-cell;\n	vertical-align: middle;\n}\n\n#wonderplugintabs-TABSID > .wonderplugintabs-header-wrap .wonderplugintabs-header-menu-text {\n	font-family: \"Open Sans\", Arial, sans-serif;\n	font-size: 12px;\n	font-weight: 400;\n	vertical-align: middle;\n	color: @title-color;\n}\n\n#wonderplugintabs-TABSID > .wonderplugintabs-header-wrap .wonderplugintabs-header-menu-icon {\n	font-family: FontAwesome;\n	font-size: 14px;\n	vertical-align: middle;\n	margin: 8px;\n	color: @icon-color;\n}\n\n#wonderplugintabs-TABSID > .wonderplugintabs-header-wrap .wonderplugintabs-header-menu:hover {\n	background-color: #fff;	\n}\n\n#wonderplugintabs-TABSID > .wonderplugintabs-header-wrap .wonderplugintabs-header-menu-dropdown {\n	box-sizing: border-box;\n	display: none;\n	position: absolute;\n	white-space: nowrap;\n	bottom: 0;\n	left: 100%;	\n	border-top: 1px solid #ccc;\n	border-right: 1px solid #ccc;\n	border-bottom: 1px solid #ccc;\n	box-shadow: 0 6px 12px rgba(0,0,0,.175);\n}\n\n#wonderplugintabs-TABSID > .wonderplugintabs-header-wrap .wonderplugintabs-header-menu-dropdown-item {\n	padding: 12px 32px 12px 20px;	\n	cursor: pointer;\n	text-align: left;\n	background-color: #fff;\n}\n\n#wonderplugintabs-TABSID > .wonderplugintabs-header-wrap .wonderplugintabs-header-menu-dropdown-item:hover {\n	background-color: #f9f9f9;	\n}\n\n#wonderplugintabs-TABSID > .wonderplugintabs-header-wrap .wonderplugintabs-header-icon-fontawesome {\n	font-family: FontAwesome;\n	line-height: @icon-size;\n	font-size: @icon-size;\n	vertical-align: middle;\n	margin: 8px;\n	color: @icon-color;\n}\n\n#wonderplugintabs-TABSID > .wonderplugintabs-header-wrap .wonderplugintabs-header-icon-image {\n	margin: 4px;\n	vertical-align: middle;\n}\n\n#wonderplugintabs-TABSID > .wonderplugintabs-header-wrap .wonderplugintabs-header-title {\n	display: inline-block;\n	margin: 4px;\n	font-family: \"Open Sans\", Arial, sans-serif;\n	font-size: 12px;\n	font-weight: 400;\n	vertical-align: middle;\n	color: @title-color;\n	white-space: nowrap;\n}\n\n#wonderplugintabs-TABSID > .wonderplugintabs-header-wrap-fullwidth {\n	float: none;\n}\n\n#wonderplugintabs-TABSID > .wonderplugintabs-panel-wrap-fullwidth {\n	left: 0;\n}\n\n#wonderplugintabs-TABSID > .wonderplugintabs-header-wrap .wonderplugintabs-header-li-fullwidth {\n	display: block;\n	margin: 0;\n	border: 1px solid #ccc;\n	border-bottom: none;\n	text-align: left;\n	border-top-left-radius: 4px;\n	border-top-right-radius: 4px;\n	border-bottom-left-radius: 0px;\n	border-bottom-right-radius: 0px;\n}\n\n#wonderplugintabs-TABSID > .wonderplugintabs-panel-wrap {\n	box-sizing: border-box;\n	position: relative;\n	display: block;\n	overflow: hidden;\n	border: 1px solid #ccc;\n	background-color: #fff;	\n	left: -1px;\n}\n\n#wonderplugintabs-TABSID > .wonderplugintabs-panel-wrap > .wonderplugintabs-panel {\n	box-sizing: border-box;\n	display: block;\n	visibility: hidden;\n	position: absolute;\n	top: 0;\n	left: 0;\n	width: 100%;\n	text-align: @panel-text-align;\n	padding: @panel-padding;\n}\n\n#wonderplugintabs-TABSID > .wonderplugintabs-panel-wrap > .wonderplugintabs-panel-active {\n	position: relative;\n}\n\n#wonderplugintabs-TABSID > .wonderplugintabs-header-wrap .wonderplugintabs-header-ul-fullwidth {\n	white-space: normal;\n}\n\n#wonderplugintabs-TABSID > .wonderplugintabs-header-wrap .wonderplugintabs-header-li-fullwidth {\n	border-radius: 0;\n}\n\n#wonderplugintabs-TABSID > .wonderplugintabs-header-wrap  .wonderplugintabs-panel {\n	padding: @panel-padding;\n	text-align: @panel-text-align;\n}\n\n#wonderplugintabs-TABSID > .wonderplugintabs-header-wrap  .wonderplugintabs-panel-active {\n	position: relative;\n}\n\n#wonderplugintabs-TABSID > .wonderplugintabs-header-wrap .wonderplugintabs-header-li-fullwidth .wonderplugintabs-header-caption:after {\n	position:absolute;\n	color:@title-color;\n	top: 12px;\n	right:8px;\n	content: \"\\f107\";\n	font-family: FontAwesome;\n	font-size: 16px;\n	font-weight:400;\n}\n\n#wonderplugintabs-TABSID > .wonderplugintabs-header-wrap .wonderplugintabs-header-li-fullwidth.wonderplugintabs-header-li-active .wonderplugintabs-header-caption:after {\n	content: \"\\f106\";\n}'
	},
	
	horizontaltopnav: {
		usetablecellfortitle:			false,
		fixedheadersize:				false,
		fullwidthtabs:					false,
		accordion:						false,
		width: 							800,
		heightmode:						'auto',
		height: 						400,
		minheight:						300,
		triggerresize:					true,
		triggerresizeonload:			true,
		triggerresizeonloadtimeout:		100,
		disablewpautop:					false,
		firstid:						0,
		extendedheight:					false,
		responsive:						true,
		fullwidth:						false,
		direction:						'horizontal',
		tabposition:					'top',
		tabiconposition:				'top',
		horizontaltabalign:				'center',
		fullwidthtabsonsmallscreen:		false,
		accordiononsmallscreen:			false,
		fullwidthtabsonsmallscreenwidth:480,
		hidetitleonsmallscreen:			false,
		hidetitleonsmallscreenwidth: 	768,
		responsivemode:					'arrow',
		tabarrowmode:					'slide',
		horizontalarrowwidthsameasheight:'pixels',
		horizontalarrowwidth:			48,
		arrowprevicon:					'fa-chevron-left',
		arrownexticon:					'fa-chevron-right',
		arrowfontsize:					20,
		arrowfontcolor:					'#666',
		dropdownmenutext:				'More',
		dropdownmenuicon:				'fa-angle-down',
		skinoptions:					'{"title-color" : ["color", "#333", "Title color"], "title-active-color" : ["color", "#cc0000", "Title active color"], "icon-color" : ["color", "#666", "FontAwesome icon color"], "icon-size" : ["pixel", "18", "Fontawesome icon size"], "tab-margin" : ["pixel", "4", "Tab margin"], "panel-padding" : ["pixel", "24", "Panel padding"], "panel-text-align" : ["align", "left", "Panel text align"] }',
		skincss:						'@import url(\'https://fonts.googleapis.com/css?family=Open+Sans:400,300,600\');\n\n#wonderplugintabs-TABSID > .wonderplugintabs-header-wrap {\n	box-sizing: border-box;\n	display: block;\n	position: relative;\n	width: 100%;	\n	z-index: 1;\n}\n\n#wonderplugintabs-TABSID > .wonderplugintabs-header-wrap .wonderplugintabs-header-inner-wrap {\n	box-sizing: border-box;\n	display: block;\n	overflow: hidden;	\n}\n\n#wonderplugintabs-TABSID > .wonderplugintabs-header-wrap .wonderplugintabs-header-ul {\n	box-sizing: border-box;\n	display: block;\n	position: relative;\n	list-style: none;\n	white-space: nowrap;\n	margin: 0;\n	padding: 0;\n}\n\n#wonderplugintabs-TABSID > .wonderplugintabs-header-wrap .wonderplugintabs-header-caption {\n	cursor: pointer;\n	padding: 8px;\n}\n\n#wonderplugintabs-TABSID > .wonderplugintabs-header-wrap .wonderplugintabs-header-li {\n	box-sizing: border-box;\n	display: inline-block;\n	position: relative;\n	margin: 0 @tab-margin 0 0;\n	padding: 0;\n	vertical-align: middle;\n}\n\n#wonderplugintabs-TABSID > .wonderplugintabs-header-wrap .wonderplugintabs-header-li-next {\n}\n\n#wonderplugintabs-TABSID > .wonderplugintabs-header-wrap .wonderplugintabs-header-li:hover {\n}\n\n#wonderplugintabs-TABSID > .wonderplugintabs-header-wrap .wonderplugintabs-header-li-active {\n}\n\n#wonderplugintabs-TABSID > .wonderplugintabs-header-wrap .wonderplugintabs-header-li-active-last {\n}\n\n#wonderplugintabs-TABSID > .wonderplugintabs-header-wrap .wonderplugintabs-header-li-first {\n}\n\n#wonderplugintabs-TABSID > .wonderplugintabs-header-wrap .wonderplugintabs-header-li-first-side-arrows {\n	margin-left: @tab-margin;\n}\n\n#wonderplugintabs-TABSID > .wonderplugintabs-header-wrap .wonderplugintabs-header-li-last {\n}\n\n#wonderplugintabs-TABSID > .wonderplugintabs-header-wrap .wonderplugintabs-header-li-last-side-arrows {\n}\n\n#wonderplugintabs-TABSID > .wonderplugintabs-header-wrap .wonderplugintabs-header-prev {\n	display: none;\n	text-align: center;\n	position: absolute;\n	top: 0;\n	left: 0;\n	cursor: pointer;\n}\n\n#wonderplugintabs-TABSID > .wonderplugintabs-header-wrap .wonderplugintabs-header-prev:before {\n	position: relative;\n	top: 50%;\n	font-family: FontAwesome;\n	margin-top: -9px;\n	display: block;\n	opacity: 0.6;\n}\n\n#wonderplugintabs-TABSID > .wonderplugintabs-header-wrap .wonderplugintabs-header-prev:hover:before {\n	opacity: 1;\n}\n\n#wonderplugintabs-TABSID > .wonderplugintabs-header-wrap .wonderplugintabs-header-next {\n	display: none;\n	text-align: center;\n	position: absolute;\n	top: 0;\n	right: 0;\n	cursor: pointer;\n}\n\n#wonderplugintabs-TABSID > .wonderplugintabs-header-wrap .wonderplugintabs-header-next:before {\n	position: relative;\n	top: 50%;\n	font-family: FontAwesome;\n	margin-top: -9px;\n	display: block;\n	opacity: 0.6;\n}\n\n#wonderplugintabs-TABSID > .wonderplugintabs-header-wrap .wonderplugintabs-header-next:hover:before {\n	opacity: 1;\n}\n\n#wonderplugintabs-TABSID > .wonderplugintabs-header-wrap .wonderplugintabs-header-menu {\n	box-sizing: border-box;\n	display: none;\n	text-align: center;\n	position: absolute;\n	top: 0;\n	right: 0;\n	cursor: pointer;\n	padding: 8px;\n}\n\n#wonderplugintabs-TABSID > .wonderplugintabs-header-wrap .wonderplugintabs-header-menu-caption {\n	display: table-cell;\n	vertical-align: middle;\n}\n\n#wonderplugintabs-TABSID > .wonderplugintabs-header-wrap .wonderplugintabs-header-menu-text {\n	font-family: \"Open Sans\", Arial, sans-serif;\n	font-size: 12px;\n	font-weight: 400;\n	vertical-align: middle;\n	color: #333;\n}\n\n#wonderplugintabs-TABSID > .wonderplugintabs-header-wrap .wonderplugintabs-header-menu-icon {\n	font-family: FontAwesome;\n	font-size: 14px;\n	vertical-align: middle;\n	margin: 8px;\n	color: #666;\n}\n\n#wonderplugintabs-TABSID > .wonderplugintabs-header-wrap .wonderplugintabs-header-menu:hover {\n	}\n\n#wonderplugintabs-TABSID > .wonderplugintabs-header-wrap .wonderplugintabs-header-menu-dropdown {\n	box-sizing: border-box;\n	display: none;\n	position: absolute;\n	white-space: nowrap;\n	top: 100%;\n	right: 0;	\n	border: 1px solid #ccc;\n	box-shadow: 0 6px 12px rgba(0,0,0,.175);\n}\n\n#wonderplugintabs-TABSID > .wonderplugintabs-header-wrap .wonderplugintabs-header-menu-dropdown-item {\n	padding: 12px 32px 12px 20px;	\n	cursor: pointer;\n	text-align: left;\n	background-color: #fff;\n}\n\n#wonderplugintabs-TABSID > .wonderplugintabs-header-wrap .wonderplugintabs-header-menu-dropdown-item:hover {\n	background-color: #f9f9f9;	\n}\n\n#wonderplugintabs-TABSID > .wonderplugintabs-header-wrap .wonderplugintabs-header-icon-fontawesome {\n	font-family: FontAwesome;\n	line-height: @icon-size;\n	font-size: @icon-size;\n	vertical-align: middle;\n	margin: 8px;\n	color: @icon-color;\n	opacity: 0.8;\n}\n\n#wonderplugintabs-TABSID > .wonderplugintabs-header-wrap .wonderplugintabs-header-li:hover .wonderplugintabs-header-icon-fontawesome,\n#wonderplugintabs-TABSID > .wonderplugintabs-header-wrap .wonderplugintabs-header-li-active .wonderplugintabs-header-icon-fontawesome {\n	opacity: 1;\n}\n\n#wonderplugintabs-TABSID > .wonderplugintabs-header-wrap .wonderplugintabs-header-icon-image {\n	margin: 4px;\n	vertical-align: middle;\n	opacity: 0.8;\n}\n\n#wonderplugintabs-TABSID > .wonderplugintabs-header-wrap .wonderplugintabs-header-li:hover .wonderplugintabs-header-icon-image,\n#wonderplugintabs-TABSID > .wonderplugintabs-header-wrap .wonderplugintabs-header-li-active .wonderplugintabs-header-icon-image {\n	opacity: 1;\n}\n\n#wonderplugintabs-TABSID > .wonderplugintabs-header-wrap .wonderplugintabs-header-title {\n	display: inline-block;\n	margin: 4px;\n	font-family: \"Open Sans\", Arial, sans-serif;\n	font-size: 14px;\n	font-weight: 300;\n	vertical-align: middle;\n	color: @title-color;\n}\n\n#wonderplugintabs-TABSID > .wonderplugintabs-header-wrap .wonderplugintabs-header-li:hover .wonderplugintabs-header-title,\n#wonderplugintabs-TABSID > .wonderplugintabs-header-wrap .wonderplugintabs-header-li-active .wonderplugintabs-header-title {\n	color: @title-active-color;\n}\n \n#wonderplugintabs-TABSID > .wonderplugintabs-header-wrap .wonderplugintabs-header-li-fullwidth {\n	display: block;\n	margin: 0;\n	text-align: center;\n}\n\n#wonderplugintabs-TABSID > .wonderplugintabs-panel-wrap {\n	box-sizing: border-box;\n	position: relative;\n	display: block;\n	width: 100%;\n	overflow: hidden;\n}\n\n#wonderplugintabs-TABSID > .wonderplugintabs-panel-wrap > .wonderplugintabs-panel {\n	box-sizing: border-box;\n	display: block;\n	visibility: hidden;\n	position: absolute;\n	top: 0;\n	left: 0;\n	width: 100%;\n	text-align: @panel-text-align;\n	padding: @panel-padding;\n}\n\n#wonderplugintabs-TABSID > .wonderplugintabs-panel-wrap > .wonderplugintabs-panel-active {\n	position: relative;\n}\n\n#wonderplugintabs-TABSID > .wonderplugintabs-header-wrap .wonderplugintabs-header-ul-fullwidth {\n	white-space: normal;\n}\n\n#wonderplugintabs-TABSID > .wonderplugintabs-header-wrap .wonderplugintabs-header-li-fullwidth {\n	border-radius: 0;\n}\n\n#wonderplugintabs-TABSID > .wonderplugintabs-header-wrap  .wonderplugintabs-panel {\n	padding: @panel-padding;\n	text-align: @panel-text-align;\n}\n\n#wonderplugintabs-TABSID > .wonderplugintabs-header-wrap  .wonderplugintabs-panel-active {\n	position: relative;\n}'
	},
	
	horizontalbottomnav: {
		usetablecellfortitle:			false,
		fixedheadersize:				false,
		fullwidthtabs:					false,
		accordion:						false,
		width: 							800,
		heightmode:						'auto',
		height: 						400,
		minheight:						300,
		triggerresize:					true,
		triggerresizeonload:			true,
		triggerresizeonloadtimeout:		100,
		disablewpautop:					false,
		firstid:						0,
		extendedheight:					false,
		responsive:						true,
		fullwidth:						false,
		direction:						'horizontal',
		tabposition:					'bottom',
		tabiconposition:				'top',
		horizontaltabalign:				'center',
		fullwidthtabsonsmallscreen:		false,
		accordiononsmallscreen:			false,
		fullwidthtabsonsmallscreenwidth:480,
		hidetitleonsmallscreen:			false,
		hidetitleonsmallscreenwidth: 	768,
		responsivemode:					'arrow',
		tabarrowmode:					'slide',
		horizontalarrowwidthsameasheight:'pixels',
		horizontalarrowwidth:			48,
		arrowprevicon:					'fa-chevron-left',
		arrownexticon:					'fa-chevron-right',
		arrowfontsize:					20,
		arrowfontcolor:					'#666',
		dropdownmenutext:				'More',
		dropdownmenuicon:				'fa-angle-down',
		skinoptions:					'{"title-color" : ["color", "#333", "Title color"], "title-active-color" : ["color", "#cc0000", "Title active color"], "icon-color" : ["color", "#666", "FontAwesome icon color"], "icon-size" : ["pixel", "16", "Fontawesome icon size"], "tab-margin" : ["pixel", "4", "Tab margin"], "panel-padding" : ["pixel", "24", "Panel padding"], "panel-text-align" : ["align", "left", "Panel text align"] }',
		skincss:						'@import url(\'https://fonts.googleapis.com/css?family=Open+Sans:400,300,600\');\n\n#wonderplugintabs-TABSID > .wonderplugintabs-header-wrap {\n	box-sizing: border-box;\n	display: block;\n	position: relative;\n	width: 100%;	\n	z-index: 1;\n}\n\n#wonderplugintabs-TABSID > .wonderplugintabs-header-wrap .wonderplugintabs-header-inner-wrap {\n	box-sizing: border-box;\n	display: block;\n	overflow: hidden;	\n}\n\n#wonderplugintabs-TABSID > .wonderplugintabs-header-wrap .wonderplugintabs-header-ul {\n	box-sizing: border-box;\n	display: block;\n	position: relative;\n	list-style: none;\n	white-space: nowrap;\n	margin: 0;\n	padding: 0;\n}\n\n#wonderplugintabs-TABSID > .wonderplugintabs-header-wrap .wonderplugintabs-header-caption {\n	cursor: pointer;\n	padding: 8px;\n}\n\n#wonderplugintabs-TABSID > .wonderplugintabs-header-wrap .wonderplugintabs-header-li {\n	box-sizing: border-box;\n	display: inline-block;\n	position: relative;\n	margin: 0 @tab-margin 0 0;\n	padding: 0;\n	vertical-align: middle;\n}\n\n#wonderplugintabs-TABSID > .wonderplugintabs-header-wrap .wonderplugintabs-header-li-next {\n}\n\n#wonderplugintabs-TABSID > .wonderplugintabs-header-wrap .wonderplugintabs-header-li:hover {\n}\n\n#wonderplugintabs-TABSID > .wonderplugintabs-header-wrap .wonderplugintabs-header-li-active {\n}\n\n#wonderplugintabs-TABSID > .wonderplugintabs-header-wrap .wonderplugintabs-header-li-active-last {\n}\n\n#wonderplugintabs-TABSID > .wonderplugintabs-header-wrap .wonderplugintabs-header-li-first {\n}\n\n#wonderplugintabs-TABSID > .wonderplugintabs-header-wrap .wonderplugintabs-header-li-first-side-arrows {\n	margin-left: @tab-margin;\n}\n\n#wonderplugintabs-TABSID > .wonderplugintabs-header-wrap .wonderplugintabs-header-li-last {\n}\n\n#wonderplugintabs-TABSID > .wonderplugintabs-header-wrap .wonderplugintabs-header-li-last-side-arrows {\n}\n\n#wonderplugintabs-TABSID > .wonderplugintabs-header-wrap .wonderplugintabs-header-prev {\n	display: none;\n	text-align: center;\n	position: absolute;\n	top: 0;\n	left: 0;\n	cursor: pointer;\n}\n\n#wonderplugintabs-TABSID > .wonderplugintabs-header-wrap .wonderplugintabs-header-prev:before {\n	position: relative;\n	top: 50%;\n	font-family: FontAwesome;\n	margin-top: -9px;\n	display: block;\n	opacity: 0.6;\n}\n\n#wonderplugintabs-TABSID > .wonderplugintabs-header-wrap .wonderplugintabs-header-prev:hover:before {\n	opacity: 1;\n}\n\n#wonderplugintabs-TABSID > .wonderplugintabs-header-wrap .wonderplugintabs-header-next {\n	display: none;\n	text-align: center;\n	position: absolute;\n	top: 0;\n	right: 0;\n	cursor: pointer;\n}\n\n#wonderplugintabs-TABSID > .wonderplugintabs-header-wrap .wonderplugintabs-header-next:before {\n	position: relative;\n	top: 50%;\n	font-family: FontAwesome;\n	margin-top: -9px;\n	display: block;\n	opacity: 0.6;\n}\n\n#wonderplugintabs-TABSID > .wonderplugintabs-header-wrap .wonderplugintabs-header-next:hover:before {\n	opacity: 1;\n}\n\n#wonderplugintabs-TABSID > .wonderplugintabs-header-wrap .wonderplugintabs-header-menu {\n	box-sizing: border-box;\n	display: none;\n	text-align: center;\n	position: absolute;\n	top: 0;\n	right: 0;\n	cursor: pointer;\n	padding: 8px;\n}\n\n#wonderplugintabs-TABSID > .wonderplugintabs-header-wrap .wonderplugintabs-header-menu-caption {\n	display: table-cell;\n	vertical-align: middle;\n}\n\n#wonderplugintabs-TABSID > .wonderplugintabs-header-wrap .wonderplugintabs-header-menu-text {\n	font-family: \"Open Sans\", Arial, sans-serif;\n	font-size: 12px;\n	font-weight: 400;\n	vertical-align: middle;\n	color: #333;\n}\n\n#wonderplugintabs-TABSID > .wonderplugintabs-header-wrap .wonderplugintabs-header-menu-icon {\n	font-family: FontAwesome;\n	font-size: 14px;\n	vertical-align: middle;\n	margin: 8px;\n	color: #666;\n}\n\n#wonderplugintabs-TABSID > .wonderplugintabs-header-wrap .wonderplugintabs-header-menu:hover {\n	}\n\n#wonderplugintabs-TABSID > .wonderplugintabs-header-wrap .wonderplugintabs-header-menu-dropdown {\n	box-sizing: border-box;\n	display: none;\n	position: absolute;\n	white-space: nowrap;\n	top: 100%;\n	right: 0;	\n	border: 1px solid #ccc;\n	box-shadow: 0 6px 12px rgba(0,0,0,.175);\n}\n\n#wonderplugintabs-TABSID > .wonderplugintabs-header-wrap .wonderplugintabs-header-menu-dropdown-item {\n	padding: 12px 32px 12px 20px;	\n	cursor: pointer;\n	text-align: left;\n	background-color: #fff;\n}\n\n#wonderplugintabs-TABSID > .wonderplugintabs-header-wrap .wonderplugintabs-header-menu-dropdown-item:hover {\n	background-color: #f9f9f9;	\n}\n\n#wonderplugintabs-TABSID > .wonderplugintabs-header-wrap .wonderplugintabs-header-icon-fontawesome {\n	font-family: FontAwesome;\n	line-height: @icon-size;\n	font-size: @icon-size;\n	vertical-align: middle;\n	margin: 8px;\n	color: @icon-color;\n	opacity: 0.8;\n}\n\n#wonderplugintabs-TABSID > .wonderplugintabs-header-wrap .wonderplugintabs-header-li:hover .wonderplugintabs-header-icon-fontawesome,\n#wonderplugintabs-TABSID > .wonderplugintabs-header-wrap .wonderplugintabs-header-li-active .wonderplugintabs-header-icon-fontawesome {\n	opacity: 1;\n}\n\n#wonderplugintabs-TABSID > .wonderplugintabs-header-wrap .wonderplugintabs-header-icon-image {\n	margin: 4px;\n	vertical-align: middle;\n	opacity: 0.8;\n}\n\n#wonderplugintabs-TABSID > .wonderplugintabs-header-wrap .wonderplugintabs-header-li:hover .wonderplugintabs-header-icon-image,\n#wonderplugintabs-TABSID > .wonderplugintabs-header-wrap .wonderplugintabs-header-li-active .wonderplugintabs-header-icon-image {\n	opacity: 1;\n}\n\n#wonderplugintabs-TABSID > .wonderplugintabs-header-wrap .wonderplugintabs-header-title {\n	display: inline-block;\n	margin: 4px;\n	font-family: \"Open Sans\", Arial, sans-serif;\n	font-size: 14px;\n	font-weight: 300;\n	vertical-align: middle;\n	color: @title-color;\n}\n\n#wonderplugintabs-TABSID > .wonderplugintabs-header-wrap .wonderplugintabs-header-li:hover .wonderplugintabs-header-title,\n#wonderplugintabs-TABSID > .wonderplugintabs-header-wrap .wonderplugintabs-header-li-active .wonderplugintabs-header-title {\n	color: @title-active-color;\n}\n\n#wonderplugintabs-TABSID > .wonderplugintabs-header-wrap .wonderplugintabs-header-li-fullwidth {\n	display: block;\n	margin: 0;\n	text-align: center;\n}\n\n#wonderplugintabs-TABSID > .wonderplugintabs-panel-wrap {\n	box-sizing: border-box;\n	position: relative;\n	display: block;\n	width: 100%;\n	overflow: hidden;\n}\n\n#wonderplugintabs-TABSID > .wonderplugintabs-panel-wrap > .wonderplugintabs-panel {\n	box-sizing: border-box;\n	display: block;\n	visibility: hidden;\n	position: absolute;\n	top: 0;\n	left: 0;\n	width: 100%;\n	text-align: @panel-text-align;\n	padding: @panel-padding;\n}\n\n#wonderplugintabs-TABSID > .wonderplugintabs-panel-wrap > .wonderplugintabs-panel-active {\n	position: relative;\n}\n\n#wonderplugintabs-TABSID > .wonderplugintabs-header-wrap .wonderplugintabs-header-ul-fullwidth {\n	white-space: normal;\n}\n\n#wonderplugintabs-TABSID > .wonderplugintabs-header-wrap .wonderplugintabs-header-li-fullwidth {\n	border-radius: 0;\n}\n\n#wonderplugintabs-TABSID > .wonderplugintabs-header-wrap  .wonderplugintabs-panel {\n	padding: @panel-padding;\n	text-align: @panel-text-align;\n}\n\n#wonderplugintabs-TABSID > .wonderplugintabs-header-wrap  .wonderplugintabs-panel-active {\n	position: relative;\n}'
	}
}; 